<?php
/*
 * Page banner settings
 * */
$default_banner_bg          = CUINARE_IMG . '/banner/banner_bg.png';
$cuinare_banner_option      = cuinare_option( 'page_banner_setting' );
$cuinare_banner_show        = isset( $cuinare_banner_option['page_show_banner'] ) ? $cuinare_banner_option['page_show_banner'] : true;
$cuinare_breadcrumb_show    = isset( $cuinare_banner_option['page_show_breadcrumb'] ) ? $cuinare_banner_option['page_show_breadcrumb'] : false;
$cuinare_page_title_disable = isset( $cuinare_banner_option['page_title_disable'] ) ? $cuinare_banner_option['page_title_disable'] : false;
$cuinare_page_title         = ! empty( $cuinare_banner_option['banner_page_title'] ) ? $cuinare_banner_option['banner_page_title'] : get_the_title();
$cuinare_banner_image       = ! empty( $cuinare_banner_option['banner_page_image']['url'] ) ? $cuinare_banner_option['banner_page_image']['url'] : $default_banner_bg;
$banner_override            = cuinare_meta_option( get_the_ID(), 'page_meta_override', false );

if ( $banner_override == true ):
	$cuinare_page_title   = cuinare_meta_option( get_the_ID(), 'header_title', get_the_title() );
	$banner_service_image = cuinare_meta_option( get_the_ID(), 'header_image', [] );
	$cuinare_banner_image = ! empty( $banner_service_image['url'] ) ? $banner_service_image['url'] : $default_banner_bg;

endif;
if ( $cuinare_banner_image != '' ) {
	$cuinare_banner_image = 'style="background-image:url(' . esc_url( $cuinare_banner_image ) . ');"';
}

?>

<?php if ( $cuinare_banner_show == true ): ?>

    <section class="xs-breadcrumb breadcrumb-height">
        <div class="breadcrumb-bg banner-area <?php echo esc_attr( $cuinare_banner_image == '' ? 'banner-solid' : 'banner-bg' ); ?>" <?php echo cuinare_kses( $cuinare_banner_image ); ?>>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-12">
                        <div class="banner-heading text-center">

							<?php if ( $cuinare_page_title_disable == false ): ?>
                                <h1>
									<?php
									if ( is_archive() ) {
										the_archive_title();
									} else {
										echo esc_html( $cuinare_page_title );
									}
									?>
                                </h1>
							<?php endif; ?>
							<?php if ( $cuinare_breadcrumb_show == true ): ?>
								<?php cuinare_get_breadcrumbs( " " ); ?>
							<?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

<?php endif;

