<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Customizer Option: Header
 */
CSF::createSection( $prefix, [
	'parent' => 'theme_settings',
	'title'  => esc_html__( 'Header Settings', 'cuinare' ),
	'fields' => [
		[
			'id'       => 'header_builder_enable',
			'type'     => 'switcher',
			'title'    => esc_html__( 'Header builder Enable', 'cuinare' ),
			'default'  => true,
			'text_on'  => esc_html__( 'Yes', 'cuinare' ),
			'text_off' => esc_html__( 'No', 'cuinare' ),
		],
		[
			'id'         => 'edit_header',
			'type'       => 'heading',
			'title'      => esc_html__( 'Edit builder header from:', 'cuinare' ),
			'content'    => esc_html__( 'Dashboard -> ElementsKit -> Header Footer', 'cuinare' ),
			'dependency' => [ 'header_builder_enable', '==', 'true' ]
		],
		[
			'id'         => 'header_nav_search_section',
			'type'       => 'switcher',
			'title'      => esc_html__( 'Search button show', 'cuinare' ),
			'desc'       => esc_html__( 'do you want to show search button in header ? ', 'cuinare' ),
			'default'    => false,
			'text_on'    => esc_html__( 'Yes', 'cuinare' ),
			'text_off'   => esc_html__( 'No', 'cuinare' ),
			'dependency' => [ 'header_builder_enable', '==', 'false' ]
		],
	],
] );