<?php

if ( ! defined( 'ABSPATH' ) ) exit;

class cuinare_Shortcode{

	/**
     * Holds the class object.
     *
     * @since 1.0
     *
     */
    public static $_instance;
    
	public static $tabs = [];

    /**
     * Localize data array
     *
     * @var array
     */
    public $localize_data = array();

	/**
     * Load Construct
     * 
     * @since 1.0
     */

	public function __construct(){
        add_action('elementskit/loaded', [$this, 'init']);
        add_action('elementor/controls/controls_registered', array( $this, 'cuinare_ekit_icon_pack' ), 120 );
        add_action('elementor/init', array($this, 'cuinare_elementor_init'));

		$this->cuinare_icon_pack();
    }


	public function init(){
        add_action('elementor/widgets/widgets_registered', array($this, 'cuinare_shortcode_elements'));
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'editor_enqueue_styles' ) );
        add_action( 'elementor/frontend/before_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
        add_action( 'elementor/preview/enqueue_styles', array( $this, 'preview_enqueue_scripts' ) );

	}


    /**
     * Enqueue Scripts
     *
     * @return void  
     */ 
    
     public function enqueue_scripts() {
       wp_enqueue_script( 'cuinare-main-elementor', CUINARE_JS  . '/elementor.js',array( 'jquery', 'elementor-frontend' ), CUINARE_VERSION, true );
    }

    /**
     * Enqueue editor styles
     *
     * @return void
     */

    public function editor_enqueue_styles() {
        wp_enqueue_style( 'cuinare-icon-elementor', CUINARE_CSS.'/icon-font.css',null, CUINARE_VERSION );

    }

    /**
     * Preview Enqueue Scripts
     *
     * @return void
     */

    public function preview_enqueue_scripts() {
        wp_enqueue_style('cuinare-elementor-editor', CUINARE_CSS . '/editor.css', null, CUINARE_VERSION);
    }

	/**
     * Elementor Initialization
     * 
     *
     * @since 1.0
     *
     */

    public function cuinare_elementor_init(){
    
        \Elementor\Plugin::$instance->elements_manager->add_category(
            'cuinare-elements',
            [
                'title' => esc_html__( 'cuinare', 'cuinare' ),
                'icon' => 'fa fa-plug',
            ],
            1
        );
    }

    /**
     * Extend Icon pack core controls.
     *
     * @param  object $controls_manager Controls manager instance.
     * @return void
     */ 
    public function cuinare_ekit_icon_pack( $controls_manager ) {

        require_once CUINARE_EDITOR_ELEMENTOR. '/controls/icon.php';

        $controls = array(
            $controls_manager::ICON => 'CUINARE_Icon_Controler',
        );

        foreach ( $controls as $control_id => $class_name ) {
            $controls_manager->unregister_control( $control_id );
            $controls_manager->register_control( $control_id, new $class_name() );
        }

    }

    

    public function cuinare_icon_pack(  ) {

		$this->__generate_font();
		
		add_filter( 'elementor/icons_manager/additional_tabs', function(){
                return apply_filters( 'elementor/icons_manager/native', [
                    
					'icon-cuinare' => [
						'name' => 'icon-cuinare',
						'label' => esc_html__( 'Cuinare Icon', 'cuinare' ),
						'url' => CUINARE_CSS . '/icon-font.css',
						'enqueue' => [ CUINARE_CSS . '/icon-font.css' ],
						'prefix' => 'tsicon-',
						'displayPrefix' => 'tsicon',
						'labelIcon' => 'tsicon-rocket-solid',
						'ver' => '5.9.1',
						'fetchJson' => CUINARE_JS . '/icon-font.js',
						'native' => true,
					]
                ]);
            }
        );
		
    }
	
	public function __generate_font(){
		global $wp_filesystem;
 
        require_once ( ABSPATH . '/wp-admin/includes/file.php' );
        WP_Filesystem();
        $css_file =  CUINARE_CSS_DIR . '/icon-font.css';
     
        if ( $wp_filesystem->exists( $css_file ) ) {
            $css_source = $wp_filesystem->get_contents( $css_file );
        } // End If Statement
        
		preg_match_all( "/\.(tsicon-.*?):\w*?\s*?{/", $css_source, $matches, PREG_SET_ORDER, 0 );
		$iconList = [];
		
		foreach ( $matches as $match ) {
			$new_icons[$match[1] ] = str_replace('tsicon-', '', $match[1]);
			$iconList[] = str_replace('tsicon-', '', $match[1]);
		}

		$icons = new \stdClass();
		$icons->icons = $iconList;
		$icon_data = json_encode($icons);
		
		$file = CUINARE_THEME_DIR . '/assets/js/icon-font.js';
          
            global $wp_filesystem;
            require_once ( ABSPATH . '/wp-admin/includes/file.php' );
            WP_Filesystem();
            if ( $wp_filesystem->exists( $file ) ) {
                $content =  $wp_filesystem->put_contents( $file, $icon_data) ;
            } 
		
	}
 
    public function cuinare_shortcode_elements($widgets_manager){

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/pricing.php';
        $widgets_manager->register_widget_type(new Elementor\Cuinare_Pricing_Widget());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/advanced-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Cuinare_Advanced_Slider());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/search.php';
        $widgets_manager->register_widget_type(new Elementor\Cuinare_Search_Widget());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/back-to-top.php';
        $widgets_manager->register_widget_type(new Elementor\Cuinare_Back_To_Top_Widget());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/logo.php';
        $widgets_manager->register_widget_type(new Elementor\Cuinare_Site_Logo_Widget());
        
        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/product-category-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Product_Category_Slider());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/vendor-grid.php';
        $widgets_manager->register_widget_type(new Elementor\cuinare_Vendor_Grid());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/product-category-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Product_Category_Slider());

        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/multivendor-product-slider.php';
        $widgets_manager->register_widget_type(new Elementor\Multivendor_Product_Slider());
        
        require_once CUINARE_EDITOR_ELEMENTOR.'/widgets/woo-mini-cart/woo-mini-cart.php';
        $widgets_manager->register_widget_type(new Elementor\Widget_Woo_Mini_Cart());

        if(class_exists('\Elementor\Cuinare_Widget_Blog_Posts')){
            $widgets_manager->register_widget_type(new Elementor\Cuinare_Widget_Blog_Posts());
        }

        if(class_exists('\Elementor\Cuinare_Widget_Client_Logo')){
            $widgets_manager->register_widget_type(new Elementor\Cuinare_Widget_Client_Logo());
        }  
         

    }
    
	public static function cuinare_get_instance() {
        if (!isset(self::$_instance)) {
            self::$_instance = new cuinare_Shortcode();
        }
        return self::$_instance;
    }

}
cuinare_Shortcode::cuinare_get_instance();