<?php

$default_banner_bg          = CUINARE_IMG . '/banner/banner_bg.png';
$cuinare_banner_option      = cuinare_option( 'blog_banner_setting' );
$cuinare_banner_show        = isset( $cuinare_banner_option['blog_show_banner'] ) ? $cuinare_banner_option['blog_show_banner'] : true;
$cuinare_breadcrumb_show    = isset( $cuinare_banner_option['blog_show_breadcrumb'] ) ? $cuinare_banner_option['blog_show_breadcrumb'] : false;
$cuinare_page_title_disable = isset( $cuinare_banner_option['page_title_disable'] ) ? $cuinare_banner_option['page_title_disable'] : false;
$cuinare_page_title         = ! empty( $cuinare_banner_option['banner_page_title'] ) ? $cuinare_banner_option['banner_page_title'] : get_bloginfo( 'name' );;
$cuinare_banner_image       = ! empty( $cuinare_banner_option['banner_blog_image']['url'] ) ? $cuinare_banner_option['banner_blog_image']['url'] : $default_banner_bg;
$cuinare_page_title         = ! empty( $cuinare_banner_option['banner_blog_title'] ) ? $cuinare_banner_option['banner_blog_title'] : esc_html__( 'Cuinare', 'cuinare' );
if ( $cuinare_banner_image != '' ) {
	$cuinare_banner_image = 'style="background-image:url(' . esc_url( $cuinare_banner_image ) . ');"';
}

?>

<?php if ( $cuinare_banner_show == true ): ?>

    <section
            class="banner-area <?php echo esc_attr( $cuinare_banner_image == '' ? 'banner-solid' : 'banner-bg' ); ?>" <?php echo cuinare_kses( $cuinare_banner_image ); ?>>
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-12">
                    <div class="banner-heading text-center">
						<?php if ( $cuinare_page_title_disable == false ): ?>
                            <h1>
								<?php
								if ( is_archive() ) {
									the_archive_title();
								} else {
									echo esc_html( $cuinare_page_title );
								}
								?>
                            </h1>
						<?php endif; ?>
						<?php if ( $cuinare_breadcrumb_show == true ): ?>
							<?php cuinare_get_breadcrumbs( " " ); ?>
						<?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php endif; ?>     



