<?php

namespace WpCafe_Pro\Core\Shortcodes;

defined("ABSPATH") || exit;

use WC_Product;
use WpCafe\Utils\Wpc_Utilities as Wpc_Utilities;
use WpCafe_Pro\Utils\Table_Utils as Table_Layout_Helper;

use WpCafe\Core\Base\Wpc_Settings_Field as Settings;
use WP_Post;
use WpCafe_Pro\Traits\Singleton;

/**
 * create post type class
 */
class Hook
{
    use Singleton;

    private $settings_obj = null ;
    public $wpc_message   = '';
    public $wpc_cart_css  = '';

    /**
     * call hooks
     */

    public function init(){
        $this->settings_obj = Settings::instance()->get_settings_option();

        $shortcode_arr =  array(
            'wpc_pro_food_menu_tab'      => 'food_menu_tab',
            'wpc_pro_food_menu_list'     => 'food_menu_list',
            'wpc_pro_menu_slider'        => 'food_menu_slider',
            'wpc_pro_menu_tab_with_slider' => 'food_menu_tab_with_slider',
            'wpc_pro_food_menu_loadmore' => 'food_menu_loadmore',
            'wpc_pro_business_hour'      => 'business_hour',
            'wpc_pro_menu_category_list' => 'food_menu_category_list',
            'wpc_pro_menu_location_list' => 'food_menu_location_list',
            'wpc_reservation_form_pro'   => 'reservation_form_pro',
            'wpc_reservation_with_food'  => 'reservation_with_food',
            'wpc_visual_reservation_form' => 'visual_reservation_form',
        );

        // add shortcode
        if( ! empty( $shortcode_arr)){
            foreach ($shortcode_arr as $key => $value) {
                add_shortcode( $key, [$this, $value ] );
            }
        }

        // place shortcode to a page
        add_filter('the_content', [$this, 'place_shortcode']);

        // Set the price with WooCommerce compatibility
        if (class_exists('WooCommerce')) {
            // add body classes
            add_filter('body_class', [$this, 'wpc_body_classes']);

            // search like
            add_filter('posts_where', [$this, 'title_like_posts_where'], 10, 2);
			
            // variation product
            add_action('variation/product_title', 'woocommerce_template_single_title', 5);
            add_action('variation/product_thumbnails', 'woocommerce_show_product_images', 20);
            add_action('variation/popup_content', 'woocommerce_template_single_rating', 10);
            add_action('variation/popup_content', 'woocommerce_template_single_price', 15);
            add_action('variation/popup_content', 'woocommerce_show_product_sale_flash', 10);
            add_action('variation/popup_content', 'woocommerce_template_single_excerpt', 20);
			add_action('variation/popup_content', 'woocommerce_template_single_add_to_cart', 30);

            add_filter('woocommerce_dropdown_variation_attribute_options_html', [$this, 'variation_radio_buttons'], 20, 2);
            add_filter('woocommerce_dropdown_variation_attribute_options_args', [$this, 'variation_select_add_class'], 2);
            add_filter('woocommerce_locate_template', [$this, 'wpcafe_variable_template'], 1, 3);

            // variation button
            add_filter('wpcafe/shortcode/variation', [$this, 'variation_option_content'], 10, 4);
            add_filter('wpcafe/shortcode/simple', [$this, 'simple_product_content'], 10, 4);

        }

    }

    /**
     * Variation template
     */
    public function wpcafe_variable_template($template, $template_name, $template_path){

        if ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_ONE_ID == get_the_ID() ){
            if ($template_name == "single-product/add-to-cart/variable.php") {
                return \Wpcafe_Pro::core_dir() . "template/woocommerce/single-product/add-to-cart/variable.php";
            }
            return $template;
        } elseif ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_TWO_ID == get_the_ID() ){
            return $template;
        } else {
            if ($template_name == "single-product/add-to-cart/variable.php" && isset($this->settings_obj['wpc_pro_woocommerce_variation_layout']) && $this->settings_obj['wpc_pro_woocommerce_variation_layout'] == 'on' && $template_name == "single-product/add-to-cart/variable.php") {
                return \Wpcafe_Pro::core_dir() . "template/woocommerce/single-product/add-to-cart/variable.php";
            }
            return $template;
        }
    }

    /**
     * add class in variation function
     */
    public function variation_select_add_class($args){
        if ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_ONE_ID == get_the_ID() ){
            $args['class'] = 'wpc_variation_poppup';
            return $args;
        } elseif ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_TWO_ID == get_the_ID() ){
            return $args;
        } else{
            if (isset($this->settings_obj['wpc_pro_woocommerce_variation_layout']) && $this->settings_obj['wpc_pro_woocommerce_variation_layout'] == 'on') {
                $args['class'] = 'wpc_variation_poppup';
                return $args;
            }
            return $args;
        }
    } 

    /**
     * Variation radio function
     */
    public function variation_radio_buttons($html, $args){

        if ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_ONE_ID == get_the_ID() ){
            $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
                'options'          => false,
                'attribute'        => false,
                'product'          => false,
                'selected'         => false,
                'name'             => '',
                'id'               => '',
                'class'            => '',
                'show_option_none' => esc_html__('Choose an option', 'wpcafe-pro'),
            ));
    
            if (false === $args['selected'] && $args['attribute'] && $args['product'] instanceof WC_Product) {
                $selected_key     = 'attribute_' . sanitize_title($args['attribute']);
                $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
            }
    
            $options               = $args['options'];
            $product               = $args['product'];
            $attribute             = $args['attribute'];
            $name                  = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
            $id                    = $args['id'] ? $args['id'] : sanitize_title($attribute);
            $class                 = $args['class'];
            $show_option_none      = (bool)$args['show_option_none'];
            $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : esc_html__('Choose an option', 'wpcafe-pro');
    
            if (empty($options) && !empty($product) && !empty($attribute)) {
                $attributes = $product->get_variation_attributes();
                $options    = $attributes[$attribute];
            }
    
            $radios = '<div class="wpc-variation">';
            $radios .= '<label class="wpc-variation-title">' . esc_html(wc_attribute_label($attribute)) . '<span class="dashicons dashicons-minus toggle-icon-trigger"></span></label>';
            $radios .= '<div class="wpc-variation-body variation-radios">';
            
            if (!empty($options)) {
                if ($product && taxonomy_exists($attribute)) {
                    $terms = wc_get_product_terms($product->get_id(), $attribute, array(
                        'fields' => 'all',
                    ));
    
                    foreach ($terms as $term) {
                        if (in_array($term->slug, $options, true)) {
                            $radios .= '<label for="' . esc_attr($term->slug) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '" ' . checked(sanitize_title($args['selected']), $term->slug, false) . '><span class="wpc-veriation-attribute">' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</span></label>';
                        }
                    }
                } else {
                    foreach ($options as $option) {
                        $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                        $radios    .= '<label for="' . sanitize_title($option) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($option) . '" id="' . sanitize_title($option) . '" ' . $checked . '><span class="wpc-veriation-attribute">' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</span></label>';
                    }
                }
            }
            
            $radios .= '</div></div>';
    
            return $html . $radios;
        } elseif ( WPC_DEMO_SITE === true && WPC_VARIATION_TEMPLATE_TWO_ID == get_the_ID() ){
            return $html;
        } else {
            if (isset($this->settings_obj['wpc_pro_woocommerce_variation_layout']) && $this->settings_obj['wpc_pro_woocommerce_variation_layout'] == 'on') {
                $args = wp_parse_args(apply_filters('woocommerce_dropdown_variation_attribute_options_args', $args), array(
                    'options'          => false,
                    'attribute'        => false,
                    'product'          => false,
                    'selected'         => false,
                    'name'             => '',
                    'id'               => '',
                    'class'            => '',
                    'show_option_none' => esc_html__('Choose an option', 'wpcafe-pro'),
                ));
        
                if (false === $args['selected'] && $args['attribute'] && $args['product'] instanceof WC_Product) {
                    $selected_key     = 'attribute_' . sanitize_title($args['attribute']);
                    $args['selected'] = isset($_REQUEST[$selected_key]) ? wc_clean(wp_unslash($_REQUEST[$selected_key])) : $args['product']->get_variation_default_attribute($args['attribute']);
                }
        
                $options               = $args['options'];
                $product               = $args['product'];
                $attribute             = $args['attribute'];
                $name                  = $args['name'] ? $args['name'] : 'attribute_' . sanitize_title($attribute);
                $id                    = $args['id'] ? $args['id'] : sanitize_title($attribute);
                $class                 = $args['class'];
                $show_option_none      = (bool)$args['show_option_none'];
                $show_option_none_text = $args['show_option_none'] ? $args['show_option_none'] : esc_html__('Choose an option', 'wpcafe-pro');
        
                if (empty($options) && !empty($product) && !empty($attribute)) {
                    $attributes = $product->get_variation_attributes();
                    $options    = $attributes[$attribute];
                }
        
                $radios = '<div class="wpc-variation">';
                $radios .= '<label class="wpc-variation-title">' . esc_html(wc_attribute_label($attribute)) . '<span class="dashicons dashicons-minus toggle-icon-trigger"></span></label>';
                $radios .= '<div class="wpc-variation-body variation-radios">';
                
                if (!empty($options)) {
                    if ($product && taxonomy_exists($attribute)) {
                        $terms = wc_get_product_terms($product->get_id(), $attribute, array(
                            'fields' => 'all',
                        ));
        
                        foreach ($terms as $term) {
                            if (in_array($term->slug, $options, true)) {
                                $radios .= '<label for="' . esc_attr($term->slug) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($term->slug) . '" ' . checked(sanitize_title($args['selected']), $term->slug, false) . '><span class="wpc-veriation-attribute">' . esc_html(apply_filters('woocommerce_variation_option_name', $term->name)) . '</span></label>';
                            }
                        }
                    } else {
                        foreach ($options as $option) {
                            $checked    = sanitize_title($args['selected']) === $args['selected'] ? checked($args['selected'], sanitize_title($option), false) : checked($args['selected'], $option, false);
                            $radios    .= '<label for="' . sanitize_title($option) . '"><input type="radio" name="' . esc_attr($name) . '" value="' . esc_attr($option) . '" id="' . sanitize_title($option) . '" ' . $checked . '><span class="wpc-veriation-attribute">' . esc_html(apply_filters('woocommerce_variation_option_name', $option)) . '</span></label>';
                        }
                    }
                }
                
                $radios .= '</div></div>';
        
                return $html . $radios;
            }
            return $html;
        }
    }





    /**
     * Food by location
     */
    public function food_location_menu( $atts ){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $unique_id = md5(md5(microtime()));

        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories'   => '',
                'style'                 => 'style-3',
                'no_of_product'         => 5,
                'show_thumbnail'        => "yes",
                'wpc_cart_button'       => 'yes',
                'title_link_show'       => 'yes',
                'wpc_menu_col'          => '6',
                'wpc_show_desc'         => 'yes',
                'wpc_desc_limit'        => '15',
                'live_search'           => 'yes',
                'wpc_delivery_time_show'=> 'yes',
                'show_item_status'      => 'yes',
                'wpc_btn_text'          => '',
                'customize_btn'         => '',
                'wpc_menu_order'        => 'DESC',
                'wpc_nav_position'      => 'top',
                'class'                 => ''
            ], $atts ));

        $products = wc_get_products([]);
        
        $product_data = [
            'wpc_food_categories'   => $wpc_food_categories,
            'style'                 => $style,
            'no_of_product'         => $no_of_product,
            'show_thumbnail'        => $show_thumbnail,
            'wpc_cart_button'       => $wpc_cart_button,
            'title_link_show'       => $title_link_show,
            'wpc_menu_col'          => $wpc_menu_col,
            'wpc_show_desc'         => $wpc_show_desc,
            'wpc_desc_limit'        => $wpc_desc_limit,
            'live_search'           => $live_search,
            'wpc_delivery_time_show'=> $wpc_delivery_time_show,
            'show_item_status'      => $show_item_status,
            'wpc_btn_text'          => $wpc_btn_text,
            'customize_btn'         => $customize_btn,
            'wpc_menu_order'        => $wpc_menu_order,
            'wpc_nav_position'      => $wpc_nav_position,
            'unique_id'             => $unique_id,
        ];

        if ( file_exists( \WpCafe_Pro::plugin_dir() . "core/shortcodes/views/food-menu/location-menu.php" ) ) {
            $col = "wpc-col-md-". $wpc_menu_col;
            ?>
            <div class="location_menu" data-product_data ="<?php esc_attr_e( json_encode( $product_data  ));?>">
                <?php include \WpCafe_Pro::plugin_dir() . "core/shortcodes/views/food-menu/location-menu.php"; ?>
            </div>
            <?php
        }

        return ob_get_clean();
    }
    



    /**
     * Update search function for live search 
     *
     */
    public function title_like_posts_where($where, $wp_query){
        global $wpdb;
        if ($post_title_like = $wp_query->get('post_title_like')) {
            $where .= ' AND ' . $wpdb->posts . '.post_title LIKE \'%' . esc_sql($wpdb->esc_like($post_title_like)) . '%\'';
        }

        return $where;
    }


    /**
     * Variation product template
     */
    public function variation_popup_template($product_id){
        // Set the main wp query for the product.
        wp('p=' . $product_id . '&post_type=product');
        while (have_posts()) :
            the_post();
        ?>
            <div id="product-<?php echo intval($product_id) ?>" <?php post_class('product wpc-row') ?>>

                <div class="wpc-col-lg-6 variation_product_image">
                    <?php do_action('variation/product_thumbnails'); ?>
                </div>
                <div class="wpc-col-lg-6">
                    <div class="wpc-single-content summary entry-summary">
                        <h2 class="product_title entry-title"><?php echo esc_html(the_title());?></h2>
                        <?php do_action('variation/popup_content'); ?>
                    </div>
                </div>
            </div>
        <?php
        endwhile; // end of the loop.
    }

    /**
     * Check discount for a product function
     */
    public function check_discount_of_product($product_id, $flag = null , $dokan_user = null ){
        $settings = $this->settings_obj;
        $wpc_pro_discount_message = '';
        $tag_message = '';
        $data = [];

        // check if multi-vendor dokan addon is activated or not

        if( !class_exists('Wpcafe_Multivendor')  ){
            $wpc_pro_discount_product   = isset($settings['wpc_pro_include_menu']) ? $settings['wpc_pro_include_menu'] : [];
            $wpc_pro_discount_cat       = isset($settings['wpc_pro_include_cat']) ? $settings['wpc_pro_include_cat'] : [];
            $wpc_pro_percentage         = isset($settings['wpc_pro_discount_percentage'])  ? sanitize_text_field($settings['wpc_pro_discount_percentage']) : null;
        }
        else{
            // apply vendor percentage
            $vendor_settings            = get_user_meta( $dokan_user , 'dokan_wpcafe_settings', true );
            $wpc_pro_discount_product   = isset($vendor_settings['wpc_pro_include_menu']) ? $vendor_settings['wpc_pro_include_menu'] : [];
            $wpc_pro_discount_cat       = isset($vendor_settings['wpc_pro_include_cat']) ? $vendor_settings['wpc_pro_include_cat'] : [];
            $wpc_pro_percentage         = isset($vendor_settings['wpc_pro_discount_percentage'])  ? sanitize_text_field($vendor_settings['wpc_pro_discount_percentage']) : null;
        }
        if (in_array($product_id, $wpc_pro_discount_product)) {
            if ($wpc_pro_percentage !== '0' && !empty($wpc_pro_percentage)) {
                $wpc_pro_discount_message .=   esc_html__("Discount " . $wpc_pro_percentage, 'wpcafe-pro') . "%";
                $tag_message .= esc_html($wpc_pro_percentage) . "%";
            }
        } else {
            // get cat id 
            $wpc_pro_terms = get_the_terms($product_id, 'product_cat');
            if (is_array($wpc_pro_terms)) {
                foreach ($wpc_pro_terms as $term) {
                    if (in_array($term->term_id, $wpc_pro_discount_cat)) {
                        if ($wpc_pro_percentage !== '0' && !empty($wpc_pro_percentage)) {
                            $wpc_pro_discount_message .=  esc_html("Discount " . $wpc_pro_percentage . "%");
                            $tag_message .= esc_html__($wpc_pro_percentage . "% off", 'wpcafe-pro');
                        }
                    }
                }
            }
        }
        if (empty($flag)) {
            $data['message'] = $wpc_pro_discount_message;
            if ($data['message'] !== '') {
                $data['percentage'] = $wpc_pro_percentage;
            } else {
                $data['percentage'] = '';
            }
        } else {
            $data['percentage_offer'] = $tag_message; // tag name
        }
        return $data;
    }

    /**
     * Show tag function
     */
    public function tag($id, $stock_status){
        ?>
        <div class="wpc-pro-tag">
            <?php
            echo \WpCafe\Utils\Wpc_Utilities::wpc_tag($id, $stock_status);
            // show discount 
            if ($stock_status == true) {
                $data = $this->check_discount_of_product($id, 'wpc_pro_tag');
                if (count($data) > 0 && $data['percentage_offer'] != '') {
            ?>
                    <ul class="wpc-menu-tag wpc-discount-offer">
                        <li><?php echo esc_html($data['percentage_offer']); ?></li>
                    </ul>
            <?php
                }
            }
            ?>
        </div>
        <?php
    }

    /**
     * Convert food preparing and delivery time for individual product
     */
    public function food_time_in_convert($time){
        $time = explode(':', $time);
        $main_time = '';
        if (is_array($time)) {
            if (isset($time[0]) && $time[0] !== '' && $time[0] !== '00') {
                $main_time .= $time[0] . " " . "hr";
            }
            if (isset($time[1]) && $time[1] !== '' && $time[1] !== '00') {
                $main_time .= $time[1] . " " . "min";
            }
        }
        return $main_time;
    }

    /**
     * Food preparing and delivery function
     */
    public function food_time($id){
        // food preparing and delivery time
        $wpc_pro_preparing_time = get_post_meta($id, 'wpc_pro_preparing_time', true);
        $wpc_pro_preparing_time = $this->food_time_in_convert($wpc_pro_preparing_time);
        $wpc_pro_delivery_time  = get_post_meta($id, 'wpc_pro_delivery_time', true);
        $wpc_pro_delivery_time  = $this->food_time_in_convert($wpc_pro_delivery_time);

        if ($wpc_pro_preparing_time !== '' || $wpc_pro_delivery_time !== '') {
        ?>
            <ul class="wpc_pro_food_time">
                <?php if ($wpc_pro_preparing_time !== '') { ?>
                    <li class="wpc_pro_food_preparing_time">
                        <span class="wpc_label_meta">
                            <?php echo esc_html__(' Preparing time : ', 'wpcafe-pro'); ?>
                        </span>
                        <span class="wpc_preparing_time">
                            <?php echo Wpc_Utilities::wpc_numeric($wpc_pro_preparing_time); ?>
                        </span>
                    </li>
                <?php }
                if ($wpc_pro_delivery_time !== '') { ?>
                    <li class="wpc_pro_food_delivery_time">
                        <span class="wpc_label_meta">
                            <?php echo esc_html__(' Delivery time : ', 'wpcafe-pro'); ?>
                        </span>
                        <span class="wpc_preparing_time">
                            <?php echo Wpc_Utilities::wpc_numeric($wpc_pro_delivery_time); ?>
                        </span>
                    </li>
                <?php } ?>
            </ul>
        <?php
        }
    }

    /**
     * Food menu tab shortcode
     */
    public function food_menu_tab($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }
        ob_start();
        $settings = $this->settings_obj;
        $atts     = Wpc_Utilities::replace_qoute( $atts );

        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories'   => '',
                'style'                  => 'style-3',
                'no_of_product'         => 5,
                'show_thumbnail'        => "yes",
                'wpc_cart_button'       => 'yes',
                'title_link_show'       => 'yes',
                'wpc_menu_col'          => '6',
                'wpc_show_desc'         => 'yes',
                'wpc_desc_limit'        => '15',
                'live_search'           => 'yes',
                'wpc_delivery_time_show'=> 'yes',
                'show_item_status'      => 'yes',
                'wpc_btn_text'          => '',
                'customize_btn'         => '',
                'wpc_menu_order'        => 'DESC',
                'wpc_nav_position'        => 'top',
            ], $atts ));


        $style = (isset($style) && $style != '') ? $style : 'style-3';

        $unique_id = md5(md5(microtime()));
        
        $wpc_cat_arr      = explode(',', $wpc_food_categories);

        $wpc_cat_sort_arr = [];
        $i                = 0;
        if (is_array($wpc_cat_arr)) {
            foreach ($wpc_cat_arr as $value) {
                $i++;

                if ($wpc_cat = get_term_by('id', $value, 'product_cat')) {
                    $wpc_get_menu_order = get_term_meta($wpc_cat->term_id, 'wpc_menu_order_priority', true);
                    if ($wpc_get_menu_order == '') {
                        $wpc_cat_sort_arr[$i] = $value;
                    } else {
                        $wpc_cat_sort_arr[$wpc_get_menu_order] = $value;
                    }
                }
            }
        }
        
        // sort category list
        if ( !empty($wpc_cat_sort_arr) ) {
            ksort($wpc_cat_sort_arr);
        }
        // render template
        include \Wpcafe_Pro::core_dir(). "shortcodes/views/food-menu/food-tab.php";

        return ob_get_clean();
    }


    /**
     * Food menu slider
     */
    public function food_menu_slider($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $atts    = Wpc_Utilities::replace_qoute( $atts );

        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories'   => '',
                'style'                 => 'style-3',
                'wpc_menu_count'        => 5,
                'wpc_slider_count'      => 3,
                'show_thumbnail'        => "yes",
                'wpc_menu_order'        => "DESC",
                'wpc_cart_button'       => 'yes',
                'title_link_show'       => 'yes',
                'wpc_show_desc'         => 'yes',
                'wpc_desc_limit'        => '15',
                'wpc_delivery_time_show' => 'yes',
                'wpc_slider_nav_show'   => 'yes',
                'wpc_slider_dot_show'   => 'yes',
                'show_item_status'      => 'yes',
                'wpc_btn_text'          => '',
                'customize_btn'         => '',
                'wpc_auto_play'         => 'yes',
            ],
            $atts
        ));
        
        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }

        $style = (isset($style) && $style != '') ? $style : 'style-1';
        $unique_id = md5(md5(microtime()));
        $wpc_cat_arr      = explode(',', $wpc_food_categories);
		$no_desc_class = ($wpc_show_desc != 'yes') ? 'wpc-no-desc' : '';

        $products_args = array(
            'post_type'     => 'product',
            'no_of_product' => $wpc_menu_count,
            'wpc_cat'       => $wpc_cat_arr,
            'order'         => $wpc_menu_order
        );
        $products = Wpc_Utilities::product_query( $products_args );
        
        ?>
        <div class="wpc-menu-slider-shortcode <?php echo esc_attr($no_desc_class); ?>">
            <?php include \Wpcafe_Pro::plugin_dir() . "/widgets/food-menu-slider/style/{$style}.php"; ?>
        </div>

        <?php
        return ob_get_clean();
    }


    /**
     * Food menu slider
     */
    public function food_menu_loadmore($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();

        $atts    = Wpc_Utilities::replace_qoute( $atts );

        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories'   => '',
                'style'                 => 'style-1',
                'no_of_product'        => 5,
                'show_thumbnail'        => "yes",
                'wpc_menu_order'        => "DESC",
                'wpc_cart_button'       => 'yes',
                'title_link_show'       => 'yes',
                'wpc_show_desc'         => 'yes',
                'wpc_desc_limit'        => '15',
                'wpc_delivery_time_show'=> 'yes',
                'show_item_status'      => 'yes',
                'wpc_btn_text'          => '',
                'customize_btn'         => '',
            ],
            $atts
        ));
        $unique_id = md5(md5(microtime()));
        $wpc_cat_arr    = explode(',', $wpc_food_categories);

        $products_args = array(
            'post_type'     => 'product',
            'no_of_product' => $no_of_product,
            'wpc_cat'       => $wpc_cat_arr,
            'order'         => $wpc_menu_order
        );
        $products 		= Wpc_Utilities::product_query( $products_args );

        $total_product_args = array(
            'post_type'     => 'product',
            'no_of_product' => $no_of_product,
            'wpc_cat'       => $wpc_cat_arr,
            'order'         => $wpc_menu_order,
            'total_count'   => true,
        );
		$total_products = count( Wpc_Utilities::product_query( $total_product_args ) );

        $widget_data = [
			'show_item_status'           => $show_item_status,
			'show_thumbnail'             => $show_thumbnail,
			'wpc_cart_button_show'       => $wpc_cart_button,
			'title_link_show'            => $title_link_show,
			'wpc_btn_text'               => $wpc_btn_text,
			'customize_btn'              => $customize_btn,
			'wpc_desc_limit'             => $wpc_desc_limit,
			'wpc_show_desc'              => $wpc_show_desc,
			'order'                      => $wpc_menu_order,
			'wpc_menu_count'             => $no_of_product,
			'cat_id'                     => $wpc_cat_arr,
			'total_post'                 => $total_products,
			'unique_id'					 =>	$unique_id,
            'wpc_delivery_time_show'     => 'yes',
        ];
        
        $ajax_json_data 			= json_encode( $widget_data );

        $style = (isset($style) && $style != '') ? $style : 'style-1';
        ?>
        
        <div class="wpc-nav-shortcode">
            <div class="wpc-food-wrapper wpc-menu-list-style1 wpc-widget-wrapper wpc-loadmore-wrap<?php echo esc_attr($unique_id); ?> main_wrapper_<?php echo esc_attr($unique_id); ?>" data-id="<?php echo esc_attr($unique_id); ?>">
                <?php
                    if (is_array( $products ) && count( $products )>0 ) {
                        include \Wpcafe_Pro::plugin_dir() . "/widgets/food-menu-loadmore/style/{$style}.php";
                    }
                ?>
            </div>
            <div class="loadmore-section" data-id="<?php echo esc_attr($unique_id); ?>">
                <?php if( $total_products > $no_of_product): ?>
                <div class="loadmore-btn-wrap">
                    <div class="loadmore<?php echo esc_attr($unique_id); ?> wpc-btn" data-json_grid_meta="<?php echo esc_attr($ajax_json_data); ?>" data-paged="<?php echo esc_attr(isset($paged) ? $paged : 2); ?>">
                        <?php echo esc_html__('Load More...', 'wpcafe-pro'); ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php
        return ob_get_clean();
    }

    /**
     * Food menu tab with slider
     */
    public function food_menu_tab_with_slider($atts){
        if (!class_exists('Woocommerce')) {
            return;
        }

        ob_start();
        $settings = $this->settings_obj;
        $atts    = Wpc_Utilities::replace_qoute( $atts );

        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'wpc_food_categories' => '',
                'style' => 'style-3',
                'no_of_product' => 5,
                'wpc_slider_count' => 3,
                'show_thumbnail' => "yes",
                'wpc_cart_button' => 'yes',
                'title_link_show' => 'yes',
                'wpc_menu_col' => '6',
                'wpc_show_desc' => 'yes',
                'wpc_desc_limit' => '15',
                'wpc_delivery_time_show' => 'yes',
                'wpc_slider_nav_show' => 'yes',
                'wpc_slider_dot_show' => 'yes',
                'show_item_status' => 'yes',
                'wpc_btn_text' => '',
                'customize_btn' => '',
                'wpc_auto_play' => 'yes',
            ],
            $atts
        ));

        // render template
        include \Wpcafe_Pro::core_dir() ."shortcodes/views/food-menu/food-tab-slider.php";

        return ob_get_clean();
    }

    /**
     * Food menu list block
     */
    public function food_menu_list($atts){
        if (!class_exists('Woocommerce')) { return; }
        ob_start();
        $settings = $this->settings_obj;
        $wpc_pro_standarad_off   = isset($settings['wpc_pro_discount_standarad_off_message'])  ? sanitize_text_field($settings['wpc_pro_discount_standarad_off_message']) : '';
        if ($wpc_pro_standarad_off !== '') {
        ?>
            <div class="wpc_pro_standard_offer_message"><?php echo esc_html($wpc_pro_standarad_off); ?></div>
        <?php
        }

        $atts    = Wpc_Utilities::replace_qoute( $atts );
        
        // shortcode option
        $atts = extract(shortcode_atts(
            [
                'style'                 => 'style-1',
                'wpc_food_categories'   => '',
                'show_thumbnail'        => 'yes',
                'no_of_product'         => 5,
                'live_search'           => 'yes',
                'show_item_status'      => 'yes',
                'title_link_show'       => 'yes',
                'wpc_cart_button'       => 'yes',
                'wpc_delivery_time_show' => 'yes',
                'wpc_show_desc'         => 'yes',
                'customize_btn'         => '',
                'wpc_btn_text'          => '',
                'wpc_desc_limit'        => '10',
                'wpc_menu_order'        => 'DESC',
                'wpc_menu_col'          => '2'

            ],$atts));

            if ( $wpc_menu_col == 6 ) {
                $wpc_menu_col = 2;
            } else
            if ( $wpc_menu_col == 5 ) {
                $wpc_menu_col = 2;
            } else
            if ( $wpc_menu_col == 4 ) {
                $wpc_menu_col = 3;
            } else
            if ( $wpc_menu_col == 3 ) {
                $wpc_menu_col = 4;
            } else
            if ( $wpc_menu_col == 2 ) {
                $wpc_menu_col = 6;
            } else
            if ( $wpc_menu_col == 1 ) {
                $wpc_menu_col = 12;
            }

        $wpc_cat_arr   = explode(',', $wpc_food_categories);
        $unique_id = md5(md5(microtime()));

        // render template
        include \Wpcafe_Pro::core_dir(). "shortcodes/views/food-menu/food-list.php";

        return ob_get_clean();
    }

    /**
     * Food menu category list
     */
    public function food_menu_category_list($atts){
        if (!class_exists('Woocommerce')) { return; }
        ob_start();
        // shortcode option
        $atts = extract(shortcode_atts(
            [ 'style' => 'style-1',
							'wpc_food_categories' => '',
              'category_limit' => 5,
              'hide_empty' => 'no',
              'show_count' => "yes",
              'grid_column' => 4],
            $atts ));

        // category sorting from backend
        $categories_id   = explode(',', $wpc_food_categories);

        // change grid column value
        switch ( $grid_column ) {
            case "4":
                $grid_column = 3;
                break;
            case "3":
                $grid_column = 4;
                break;
            case "2":
                $grid_column = 6;
                break;
            case 1:
                $grid_column = 12;
                break;
            default:
                $grid_column = 2;
                break;
        }

        // change hide empty value
        switch ( $hide_empty ) {
            case 'yes':
                $hide_empty = 1;
                break;
            case 'no':
                $hide_empty = 0;
                break;
            default:
                $hide_empty = 0;
                break;
        }

        // render template
        include \Wpcafe_Pro::core_dir() . "shortcodes/views/food-menu/food-categories.php";

        return ob_get_clean();
    }

    /**
     * Food menu location list
     */
    public function food_menu_location_list($atts){
        if (!class_exists('Woocommerce')) { return; }
        ob_start();
        // shortcode option
        $atts = extract(shortcode_atts(['style' => 'style-5', 'location_ids' => '', 'location_limit' => 5, 'hide_empty' => 'no', 'show_count' => "yes", 'grid_column' => 4],
            $atts
        ));

        // change grid column value
        switch ( $grid_column ) {
            case "4":
                $grid_column = 3;
                break;
            case "3":
                $grid_column = 4;
                break;
            case "2":
                $grid_column = 6;
                break;
            case 1:
                $grid_column = 12;
                break;
            default:
                $grid_column = 2;
                break;
        }

        // category sorting from backend
        $categories_id   = explode(',', $location_ids);

        // change hide empty value
        switch ( $hide_empty ) {
            case 'yes':
                $hide_empty = 1;
                break;
            case 'no':
                $hide_empty = 0;
                break;
            default:
                $hide_empty = 0;
                break;
        }

        // render template
        include \Wpcafe_Pro::core_dir() . "shortcodes/views/food-menu/food-location.php";

        return ob_get_clean();
    }

    /**
     * Show business hour function
     */
    public function business_hour($atts){
        ob_start();
        extract(shortcode_atts(['all_days_schedule' => 'yes'], $atts));
        $settings = $this->settings_obj;
        // render template
        include \Wpcafe_Pro::core_dir() . "shortcodes/views/food-menu/business-hour.php";

        return ob_get_clean();
    }

    /**
     * Place reservation shortcode to any page function
     */
    public function place_shortcode($content){
        if (!is_admin()) {
            global $post;
            if (!$post instanceof WP_Post) return $content;
            $settings = $this->settings_obj;
            if (is_array($settings)) {
                if (isset($settings['wpc_reservation_form_display_page']) && $settings['wpc_reservation_form_display_page'] !== '') {
                    if ($post->post_type == 'page' && $post->ID == $settings['wpc_reservation_form_display_page']) {
                        $shortcode = "[wpc_reservation_form wpc_image_url='']";
                        $content = $content . $shortcode;
                    }
                }
            }
        }

        return $content;
    }

    /**
     * Reservation form common markup
     *
     * @param [type] $atts
     * @return void
     */
    public function common_reservation_markup($atts , $data = [] ){

        // getting setting object
        $settings = $this->settings_obj;
        $result_data        = apply_filters('wpcafe/action/reservation_template', $atts);

        $from_field_label   = esc_html__("From", 'wpcafe-pro');
        $to_field_label = esc_html__("To", 'wpcafe-pro');
        $show_form_field = "on";
        $show_to_field = "on";
        $from_to_column     = "wpc-col-md-6"; $required_from_field = 'on'; $required_to_field = 'on';$view = 'yes'; 
        $column_lg          = 'wpc-col-lg-6'; $column_md = 'wpc-col-md-12';
        $booking_button_text = esc_html__("Confirm Booking","wpcafe-pro");
        $cancel_button_text  = esc_html__("Request Cancellation","wpcafe-pro");

        // getting style number
        $style = !empty( $atts['form_style'] ) ? $atts['form_style'] : 1 ;

        if ( is_array($result_data) ) {
            if ( isset( $result_data['calender_view']) ) {
                $view      = $result_data['calender_view'];
                $column_lg = isset($result_data['column_lg']) ? $result_data['column_lg'] : 'wpc-col-lg-6';
                $column_md = isset($result_data['column_md']) ? $result_data['column_md'] : 'wpc-col-md-12';
            }

            if(isset( $result_data['from_field_label'] ) && isset( $result_data['to_field_label'] )  ) {
                $from_field_label   =  $result_data['from_field_label'];
                $to_field_label     =  $result_data['to_field_label'];
                $show_form_field    =  $result_data['show_form_field'];
                $show_to_field      =  $result_data['show_to_field'];
                $required_from_field=  $result_data['required_from_field'];
                $required_to_field  =  $result_data['required_to_field'];

                if(!( $show_form_field =='on' && $show_to_field =='on' ) ){
                    $from_to_column = "wpc-col-md-12";
                }

                $booking_button_text = $result_data['form_booking_button'];
                $cancel_button_text = $result_data['form_cancell_button'];
            }
        }

        $seat_capacity = isset( $result_data['seat_capacity'] ) ? $result_data['seat_capacity'] : 20;
        $booking_status = isset( $result_data['booking_status'] ) ? $result_data['booking_status']: '';

        // All form settings for reservation
        if ( file_exists( \Wpcafe::plugin_dir() . "core/shortcodes/views/reservation/form-settings.php" ) ) {
            include \Wpcafe::plugin_dir() . "core/shortcodes/views/reservation/form-settings.php";
        }

        if( empty( $atts['reservation_food'] ) ){
            $reservation_form_template = \Wpcafe_Pro::plugin_dir() . "/core/shortcodes/views/reservation/style-$style.php";
        }else{
            if( $style == "style-2" ){
                $reservation_form_template = \Wpcafe_Pro::plugin_dir() . "/core/shortcodes/views/reservation/style-1.php";
            }else {
                $reservation_form_template = \Wpcafe_Pro::plugin_dir() . "/core/shortcodes/views/reservation/reservation-with-food/$style.php";
            }
        }

        extract( shortcode_atts( [
            'fluent_crm_webhook'  => '',
        ], $atts ));


        ?>
        <div class="reservation_section">
            <?php
            if( file_exists( $reservation_form_template ) ){
                include $reservation_form_template;
            }
            ?>
        </div>
        <?php
    }


    /**
     * Create a shortcode to render the reservation form.
     * Print the reservation form's HTML code.
     */
    public function reservation_form_pro($atts){

        ob_start();
        $this->common_reservation_markup( $atts );

        return ob_get_clean();
    }

    public function reservation_with_food( $atts ){
        ob_start();
        $atts['reservation_food']   = 'yes';
        $atts['calender_view']      = 'no';

        $this->common_reservation_markup( $atts );

        return ob_get_clean();
    }

    /**
     * Variation content html
     */
    public function variation_option_content($product, $customize_btn = '', $unique_id = '' , $customization_icon='wpcafe-customize'){
        // variation price
        Wpc_Utilities::get_variation_price($product);

        ?>
        <div class="wpc-menu-footer">
            <div class="wpc-customize-btn">
                <?php
                // show customize button
                if ($product->is_in_stock() == true && $product->get_type() == 'variable' || $product->get_type() == 'grouped') {
                ?>
                    <div class="wpc-add-to-cart">
                        <a href="#" id="product_popup<?php echo esc_attr($product->get_id() . $unique_id);  ?>" class="customize_button"
                        data-product_id=<?php echo intval(($product->get_id())) ?>>
                            <?php
                            if (isset($customize_btn) && $customize_btn != '') {
                                echo esc_html($customize_btn);
                            }
                            ?>
                            <i class="<?php esc_attr_e($customization_icon);?>"></i>
                        </a>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
        <?php
    }

    /**
     * Simple content html
     */
    public function simple_product_content($product, $customize_btn = '', $unique_id = '' , $customization_icon='wpcafe-customize' ){

        ?>
        <div class="wpc-menu-footer">
            <div class="wpc-customize-btn">
                <?php
                // show customize button
                if ($product->is_in_stock() == true && $product->get_type() == 'simple' ) {
                ?>
                    <div class="wpc-add-to-cart">
                        <a href="#" id="product_popup<?php echo esc_attr($product->get_id() . $unique_id);  ?>" class="customize_button" data-product_id=<?php echo intval(($product->get_id())) ?>>
                            <?php
                            if (isset($customize_btn) && $customize_btn != '') {
                                echo esc_html($customize_btn);
                            }
                            ?>
                            <i class="<?php esc_attr_e($customization_icon);?>"></i>
                        </a>
                    </div>
                <?php
                }
                ?>
            </div>
        </div>
        <?php
    }

    // add body class
    public function wpc_body_classes($classes){
        $settings       = $this->settings_obj;
        if (isset($settings['wpc_pro_woocommerce_override_css']) && $settings['wpc_pro_woocommerce_override_css'] == 'on') {
            $classes[] = 'woocomerce-layout-override-enable';
        }

        return $classes;
    }

    
    /**
     * generate markup for visual table selection shortcode
     *
     * @param [type] $atts
     * @return void
     */
    public function visual_reservation_form($atts){
        ob_start();

        $settings = $this->settings_obj;
        // get pro feature values
        $result_data = apply_filters('wpcafe/action/reservation_template', $atts );

        $from_field_label = esc_html__('From', 'wpcafe-pro');
        $to_field_label = esc_html__('To', 'wpcafe-pro');
        $show_form_field = "on";
        $show_to_field = "on";
        $from_to_column = "wpc-col-md-6";
        $required_from_field = 'on';
        $required_to_field = 'on';
        $view = 'yes';
        $column_lg = 'wpc-col-lg-6';
        $column_md = 'wpc-col-md-12';
        $first_booking_button   = esc_html__("Book a table","wpcafe-pro");
        $booking_button_text    = esc_html__("Confirm Booking","wpcafe-pro");
        $cancel_button_text     = esc_html__("Request Cancellation" ,"wpcafe-pro");

        if ( is_array($result_data) ) {
            if ( isset( $result_data['calender_view']) ) {
                $view      = $result_data['calender_view'];
                $column_lg = isset($result_data['column_lg']) ? $result_data['column_lg'] : 'wpc-col-lg-6';
                $column_md = isset($result_data['column_md']) ? $result_data['column_md'] : 'wpc-col-md-12';
            }
            if(isset( $result_data['from_field_label'] ) && isset( $result_data['to_field_label'] )  ) {
                $from_field_label   =  $result_data['from_field_label'];
                $to_field_label     =  $result_data['to_field_label'];
                $show_form_field    =  $result_data['show_form_field'];
                $show_to_field      =  $result_data['show_to_field'];
                $required_from_field=  $result_data['required_from_field'];
                $required_to_field  =  $result_data['required_to_field'];

                if(!( $show_form_field =='on' && $show_to_field =='on' ) ){
                    $from_to_column = "wpc-col-md-12";
                }

                $first_booking_button   = $result_data['first_booking_button'];
                $booking_button_text    = $result_data['form_booking_button'];
                $cancel_button_text     = $result_data['form_cancell_button'];
            }
        }

        $seat_capacity  = isset( $result_data['seat_capacity'] ) ? $result_data['seat_capacity'] : 20;

        $booking_status = isset( $result_data['booking_status'] ) ? $result_data['booking_status']: '';

        $reservation_form_template = \Wpcafe_Pro::core_dir() . "shortcodes/views/reservation/reservation-visual-selection.php";

        // All form settings for reservation
        if ( file_exists( \Wpcafe::plugin_dir() . "core/shortcodes/views/reservation/form-settings.php" ) ) {
            include_once \Wpcafe::plugin_dir() . "core/shortcodes/views/reservation/form-settings.php";
        }

        ?>
        <div class="reservation_section">
            <?php
            $is_multi_slot = ( isset($settings['reser_multi_schedule'] ) && $settings['reser_multi_schedule'] == 'on' )  ? true : false;

            $schedule_slug = Table_Layout_Helper::retrieve_slug_name();
            $all_mappings  = Table_Layout_Helper::get_settings_option( 'wpc_table_layout' );
            $has_mapping   = ( isset( $all_mappings[$schedule_slug]['chairQty'] ) && absint( $all_mappings[$schedule_slug]['chairQty'] ) > 0 )  ? true : false;
            
            $show_table_layout = ( !$is_multi_slot && $has_mapping ) ? true : false;
            if ( $show_table_layout && file_exists( $reservation_form_template ) ) {
                include_once $reservation_form_template;
            } else {
                echo esc_html__( 'Visual table reservations (mapping) work on single-slot reservations only.', 'wpcafe-pro' );
            }
            ?>
        </div>
        <?php

        return ob_get_clean();
    }
    
}
