<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


class Cuinare_Site_Logo_Widget extends Widget_Base
{


    public $base;

    public function get_name()
    {
        return 'site-logo';
    }

    public function get_title()
    {

        return esc_html__('Site Logo', 'cuinare');

    }

    public function get_icon()
    {
        return 'eicon-image';
    }

    public function get_categories()
    {
        return ['elementskit'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Logo settings', 'cuinare'),
            ]
        );

        $this->add_control(
            'site_logo',
            [
                'label' => esc_html__('Logo', 'cuinare'),
                'type' => Controls_Manager::MEDIA,

            ]
        );

        $this->add_responsive_control(
            'logo_size_width',
            [
                'label' => esc_html__('Logo Width', 'cuinare'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cuinare-widget-logo img' => 'max-width: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'logo_size_height',
            [
                'label' => esc_html__('Logo Height', 'cuinare'),
                'type' => Controls_Manager::NUMBER,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cuinare-widget-logo img' => 'max-height: {{VALUE}}px;',
                    '{{WRAPPER}} .cuinare-widget-logo a' => 'line-height: {{VALUE}}px;',
                ],
            ]
        );
        $this->add_responsive_control(
            'date_text_align', [
                'label' => esc_html__('Alignment', 'cuinare'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [

                    'left' => [
                        'title' => esc_html__('Left', 'cuinare'),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'cuinare'),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'cuinare'),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .cuinare-widget-logo' => 'text-align: {{VALUE}};'
                ],
            ]
        );


        $this->add_responsive_control(
            'logo_padding',
            [
                'label' => esc_html__('Padding', 'cuinare'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .cuinare-widget-logo' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
       
        $this->end_controls_section();
    }

    protected function render( ) { 
        $settings = $this->get_settings_for_display();

        $site_logo = $settings['site_logo'];
    ?>

<div class="cuinare-widget-logo logo">
    <a href="<?php echo esc_url(home_url('/')); ?>">
        <img width="286" height="115" class="dark" src="<?php
        if (isset($site_logo['url']) && $site_logo['url'] != '') {
            echo esc_url($site_logo['url']);
        } else {
            echo esc_url(
                cuinare_src(
                    'general_dark_logo',
                    CUINARE_IMG . '/logo.png'
                )
            );
        }
        ?>" alt="<?php bloginfo('name'); ?>">

    </a>
</div>

    <?php  
    }
    protected function content_template() { }
}