<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit;


class Cuinare_Search_Widget extends Widget_Base {


  public $base;

    public function get_name() {
        return 'cuinare-search';
    }

    public function get_title() {

        return esc_html__( 'Cuinare Search', 'cuinare' );

    }

    public function get_icon() { 
        return 'eicon-search';
    }

    public function get_categories() {
        return [ 'cuinare-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'section_tab',
            [
                'label' => esc_html__('Search settings', 'cuinare'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
    

        $this->add_control(
            'seach_field_bg_color',
            [
                'label' => esc_html__('Search BG color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-search-box .form-control' => 'background-color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'seach_field_color',
            [
                'label' => esc_html__('Search Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-search-box .form-control' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'seach_field_placehoder_color',
            [
                'label' => esc_html__('Placeholder Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-search-box .form-control::placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'search_box_border',
				'label' => esc_html__( 'Border', 'cuinare' ),
				'selector' => '{{WRAPPER}} .ts-search-box .form-control',
			]
		);
      
      $this->add_responsive_control(
			'border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .form-control' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );
      $this->add_responsive_control(
			'searchPadding',
			[
				'label' => esc_html__( 'Search Field Padding', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .form-control' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );

      $this->add_responsive_control(
			'search_field_height',
			[
			'label' =>esc_html__( 'Search Field Height', 'cuinare' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .form-control' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
      );

	$this->end_controls_section();

	$this->start_controls_section(
		'content_section',
		[
			'label' => esc_html__( 'BTN Settings', 'cuinare' ),
			'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		]
	);
      

        $this->add_control(
            'btn_text_color',
            [
                'label' => esc_html__('Search Button Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-search-box .search-button' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'btn_bg_color',
            [
                'label' => esc_html__('Search Button BG Color', 'cuinare'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .ts-search-box .search-button' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'button_border',
				'label' => esc_html__( 'Button Border', 'cuinare' ),
				'selector' => '{{WRAPPER}} .ts-search-box .search-button',
			]
		);

        $this->add_responsive_control(
			'btn_border_radius',
			[
				'label' => esc_html__( 'Border Radius', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .search-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
        );

        $this->add_responsive_control(
			'button_height',
			[
			'label' =>esc_html__( 'Button Height', 'cuinare' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .search-button' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
      );

        $this->add_responsive_control(
			'search_btn_horizontal_position',
			[
                'label' =>esc_html__( 'Button Horizontal Position', 'cuinare' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .search-button' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
        );

        $this->add_responsive_control(
			'search_btn_vertical_position',
			[
                'label' =>esc_html__( 'Button Vertical Position', 'cuinare' ),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'devices' => [ 'desktop', 'tablet', 'mobile' ],
				'desktop_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 0,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .search-button' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
        );
      
        $this->add_responsive_control(
			'btn_padding',
			[
				'label' => esc_html__('Button Padding', 'cuinare' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .ts-search-box .search-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
      );
        $this->end_controls_section();
    }

    protected function render( ) { 

        $settings = $this->get_settings();

    ?>
      <div class="ts-search-box">
         <?php  get_search_form(); ?>
      </div>

    <?php  
    }
    protected function content_template() { }
}