<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Customizer option: Banner
 */
CSF::createSection( $prefix, [
	'parent' => 'theme_settings',
	'title'  => esc_html__( 'Banner Settings', 'cuinare' ),
	'fields' => [
		[
			'id'      => 'sub_page_banner_overlay_style',
			'type'    => 'color',
			'title'   => esc_html__( 'Banner Overlay Color', 'cuinare' ),
			'default' => 'rgba(0, 0, 0, 0.4)',
		],
		[
			'id'         => 'page_banner_setting',
			'type'       => 'accordion',
			'accordions' => [
				[
					'title'  => esc_html__( 'Page Banner Settings', 'cuinare' ),
					'icon'   => '',
					'fields' => [
						[
							'id'       => 'page_show_banner',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show banner?', 'cuinare' ),
							'subtitle' => esc_html__( 'Show or hide the banner', 'cuinare' ),
							'default'  => true,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'       => 'page_show_breadcrumb',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show Breadcrumb?', 'cuinare' ),
							'subtitle' => esc_html__( 'Show or hide the Breadcrumb', 'cuinare' ),
							'default'  => false,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'       => 'page_title_disable',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Disable Page Title', 'cuinare' ),
							'default'  => false,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'NO', 'cuinare' ),
						],
						[
							'id'    => 'banner_page_title',
							'type'  => 'text',
							'title' => esc_html__( 'Banner title', 'cuinare' ),
						],
						[
							'id'             => 'banner_page_image',
							'type'           => 'media',
							'title'          => esc_html__( 'Banner image', 'cuinare' ),
							'subtitle'       => '',
							'url'            => false,
							'preview_width'  => 50,
							'preview_height' => 50,
						],
					],
				],
			],
		],
		[
			'id'         => 'blog_banner_setting',
			'type'       => 'accordion',
			'accordions' => [
				[
					'title'  => esc_html__( 'Blog Banner Settings', 'cuinare' ),
					'icon'   => '',
					'fields' => [
						[
							'id'       => 'blog_show_banner',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show Banner?', 'cuinare' ),
							'subtitle' => esc_html__( 'Show or hide the banner', 'cuinare' ),
							'default'  => true,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'       => 'blog_show_breadcrumb',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show Breadcrumb?', 'cuinare' ),
							'subtitle' => esc_html__( 'Show or hide the Breadcrumb', 'cuinare' ),
							'default'  => false,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'       => 'page_title_disable',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Disable Page Title', 'cuinare' ),
							'default'  => false,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'NO', 'cuinare' ),
						],
						[
							'id'      => 'banner_blog_title',
							'type'    => 'text',
							'title'   => esc_html__( 'Banner title', 'cuinare' ),
							'default' => esc_html__( 'Cuinare Blog', 'cuinare' ),
						],
						[
							'id'             => 'banner_blog_image',
							'type'           => 'media',
							'title'          => esc_html__( 'Image', 'cuinare' ),
							'subtitle'       => esc_html__( 'Banner blog image', 'cuinare' ),
							'url'            => false,
							'preview_width'  => 50,
							'preview_height' => 50,
						],
					],
				],
			],
		],
		[
			'id'         => 'shop_banner_settings',
			'type'       => 'accordion',
			'accordions' => [
				[
					'title'  => esc_html__( 'Shop Banner Settings', 'cuinare' ),
					'icon'   => '',
					'fields' => [
						[
							'id'       => 'show',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show banner?', 'cuinare' ),
							'default'  => true,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'       => 'show_breadcrumb',
							'type'     => 'switcher',
							'title'    => esc_html__( 'Show breadcrumb?', 'cuinare' ),
							'default'  => true,
							'text_on'  => esc_html__( 'Yes', 'cuinare' ),
							'text_off' => esc_html__( 'No', 'cuinare' ),
						],
						[
							'id'    => 'shop_banner_title',
							'type'  => 'text',
							'title' => esc_html__( 'Shop Banner title', 'cuinare' ),
						],
					],
				],
			],
		],
	],
] );