<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * Customizer Option: General
 */

CSF::createSection( $prefix, [
	'parent' => 'theme_settings',
	'title'  => esc_html__( 'Style Settings', 'cuinare' ),
	'fields' => [
		[
			'id'       => 'style_body_bg',
			'type'     => 'color',
			'title'    => esc_html__( 'Body background', 'cuinare' ),
			'subtitle' => esc_html__( 'Site\'s main background color.', 'cuinare' ),
		],
		[
			'id'       => 'style_body_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Body color', 'cuinare' ),
			'subtitle' => esc_html__( 'Site\'s main body color color.', 'cuinare' ),
		],
		[
			'id'       => 'style_primary',
			'type'     => 'color',
			'title'    => esc_html__( 'Primary color', 'cuinare' ),
			'subtitle' => esc_html__( 'Site\'s main color.', 'cuinare' ),
		],
		[
			'id'       => 'secondary_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Secondary color', 'cuinare' ),
			'subtitle' => esc_html__( 'Secondary color.', 'cuinare' ),
		],
		[
			'id'       => 'title_color',
			'type'     => 'color',
			'title'    => esc_html__( 'Title color', 'cuinare' ),
			'subtitle' => esc_html__( 'Blog title color.', 'cuinare' ),
		],
		[
			'id'       => 'load_google_fonts',  // Need to check with Rasel vai
			'type'     => 'switcher',
			'title'    => esc_html__( 'Google Fonts Load', 'cuinare' ),
			'subtitle' => esc_html__( 'Do you want to load google fonts?', 'cuinare' ),
			'default'  => true,
			'text_on'  => esc_html__( 'Yes', 'cuinare' ),
			'text_off' => esc_html__( 'No', 'cuinare' ),
		],
		[
			'id'             => 'body_font',
			'type'           => 'typography',
			'title'          => esc_html__( 'Body Font', 'cuinare' ),
			'desc'           => esc_html__( 'Choose the typography for the title', 'cuinare' ),
			'output'         => 'body',
			'default'        => array(
				'font-family' => 'Jost',
				'font-weight' => '400',
				'font-size'   => '16',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'font_style'     => true,
			'line_height'    => true,
			'text_align'     => false,
			'letter_spacing' => false,
			'text_transform' => false,
			'color'          => false,
			'subset'         => false,
			'preview'        => 'always'
		],
		[
			'id'             => 'heading_font_one',
			'type'           => 'typography',
			'title'          => esc_html__( 'Heading H1 Fonts', 'cuinare' ),
			'desc'           => esc_html__( 'This is for heading google fonts', 'cuinare' ),
			'output'         => 'h1',
			'default'        => array(
				'font-family' => 'DM Serif Display',
				'font-size'   => '36',
				'font-weight' => '400',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'font_style'     => true,
			'line_height'    => true,
			'text_align'     => false,
			'letter_spacing' => false,
			'text_transform' => false,
			'color'          => false,
			'subset'         => false,
			'preview'        => 'always'
		],
		[
			'id'             => 'heading_font_two_style',
			'type'           => 'typography',
			'title'          => esc_html__( 'Heading H2 Fonts', 'cuinare' ),
			'desc'           => esc_html__( 'This is for heading google fonts', 'cuinare' ),
			'output'         => 'h2',
			'default'        => array(
				'font-family' => 'DM Serif Display',
				'font-size'   => '30',
				'font-weight' => '400',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'font_style'     => true,
			'line_height'    => true,
			'text_align'     => false,
			'letter_spacing' => false,
			'text_transform' => false,
			'color'          => false,
			'subset'         => false,
			'preview'        => 'always'
		],
		[
			'id'             => 'heading_font_two',
			'type'           => 'typography',
			'title'          => esc_html__( 'Heading H3 Fonts', 'cuinare' ),
			'desc'           => esc_html__( 'This is for heading google fonts', 'cuinare' ),
			'output'         => 'h3',
			'default'        => array(
				'font-family' => 'DM Serif Display',
				'font-size'   => '24',
				'font-weight' => '400',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'font_style'     => true,
			'line_height'    => true,
			'text_align'     => false,
			'letter_spacing' => false,
			'text_transform' => false,
			'color'          => false,
			'subset'         => false,
			'preview'        => 'always'
		],
		[
			'id'             => 'heading_font_three',
			'type'           => 'typography',
			'title'          => esc_html__( 'Heading H4 Fonts', 'cuinare' ),
			'desc'           => esc_html__( 'This is for heading google fonts', 'cuinare' ),
			'output'         => 'h4',
			'default'        => array(
				'font-family' => 'DM Serif Display',
				'font-size'   => '18',
				'font-weight' => '400',
				'unit'        => 'px',
				'type'        => 'google',
			),
			'font_style'     => true,
			'line_height'    => true,
			'text_align'     => false,
			'letter_spacing' => false,
			'text_transform' => false,
			'color'          => false,
			'subset'         => false,
			'preview'        => 'always'
		],
	],
] );