<?php if(!defined('ABSPATH')) {
	die('Direct access forbidden.');
}
/**
 * Helper functions
 */

// simply echo the variable
// ----------------------------------------------------------------------------------------
function cuinare_return($s) {

	return wp_kses_post($s);
}

//header
function cuinare_ekit_headers($format = 'html') {

	if(class_exists('ElementsKit')) {
		$select = [];
		$args = array(
			'posts_per_page' => -1,
			'post_status'    => 'publish',
			'orderby'        => 'id',
			'order'          => 'DESC',
			'post_type'      => 'elementskit_template',
		);
		$headers = get_posts($args);
		foreach($headers as $header) {
			if(get_post_meta($header->ID, 'elementskit_template_type', true) == 'header') {
				$select[$header->ID] = $header->post_title;
			}

		}

		return $select;

	}

	return [];
}

//css unit check
function cuinare_style_unit($data) {
	$css_units = ["px", "mm", "in", "pt", "pc", "em", "vw", "%", "cm"];
	$footer_padding_top_unit = substr($data, -2);
	$footer_padding_top_unit_percent = substr($data, -1);
	if(in_array($footer_padding_top_unit, $css_units) || in_array($footer_padding_top_unit_percent, $css_units)) {
		return $data;
	} else {
		return (int)$data . "px";
	}

	return $data;
}

function cuinare_option($key = '', $default_value = '', $method = 'customizer', $meta_option_first = false) {
	switch($method) {
		case 'customizer':
			$options = get_option('cuinare_theme_settings');
			$value = (isset($options[$key])) ? $options[$key] : '';
			break;
		default:
			$value = '';
			break;
	}
	if($meta_option_first == true && cuinare_meta_option(get_the_ID(), 'override_default', false)) {
		return cuinare_meta_option(get_the_ID(), $key, $default_value);
	}

	return (!isset($value) || $value == '') ? $default_value : $value;
}

// return the specific value from metabox
// ----------------------------------------------------------------------------------------
function cuinare_meta_option($postid, $key, $default_value = '') {
	$value = get_post_meta($postid, $key, true);

	return (!isset($value) || $value == '') ? $default_value : $value;
}




// extract unyson image data from option value in a much simple way
// ----------------------------------------------------------------------------------------
function cuinare_src($key, $default_value = '', $input_as_attachment = false) { // for src
	if($input_as_attachment == true) {
		$attachment = $key;
	} else {
		$attachment = cuinare_option($key);
	}

	if(isset($attachment['url']) && !empty($attachment)) {
		return $attachment['url'];
	}

	return $default_value;
}


// return attachment alt in safe mode
// ----------------------------------------------------------------------------------------
function cuinare_alt($id) {
	if(!empty($id)) {
		$alt = get_post_meta($id, '_wp_attachment_image_alt', true);
		if(!empty($alt)) {
			$alt = $alt;
		} else {
			$alt = get_the_title($id);
		}

		return $alt;
	}
}


// get original id in WPML enabled WP
// ----------------------------------------------------------------------------------------
function cuinare_org_id($id, $name = true) {
	if(function_exists('icl_object_id')) {
		$id = icl_object_id($id, 'page', true, 'en');
	}

	if($name === true) {
		$post = get_post($id);

		return $post->post_name;
	} else {
		return $id;
	}
}


// converts rgb color code to hex format
// ----------------------------------------------------------------------------------------
function cuinare_rgb2hex($hex) {
	$hex = preg_replace("/^#(.*)$/", "$1", $hex);
	$rgb = array();
	$rgb['r'] = hexdec(substr($hex, 0, 2));
	$rgb['g'] = hexdec(substr($hex, 2, 2));
	$rgb['b'] = hexdec(substr($hex, 4, 2));

	$color_hex = $rgb["r"] . ", " . $rgb["g"] . ", " . $rgb["b"];

	return $color_hex;
}


// WP kses allowed tags
// ----------------------------------------------------------------------------------------
function cuinare_kses($raw) {

	$allowed_tags = array(
		'a'                             => array(
			'class' => array(),
			'href'  => array(),
			'rel'   => array(),
			'title' => array(),
		),
		'abbr'                          => array(
			'title' => array(),
		),
		'b'                             => array(),
		'blockquote'                    => array(
			'cite' => array(),
		),
		'cite'                          => array(
			'title' => array(),
		),
		'code'                          => array(),
		'del'                           => array(
			'datetime' => array(),
			'title'    => array(),
		),
		'dd'                            => array(),
		'div'                           => array(
			'class' => array(),
			'title' => array(),
			'style' => array(),
		),
		'dl'                            => array(),
		'dt'                            => array(),
		'em'                            => array(),
		'h1'                            => array(),
		'h2'                            => array(),
		'h3'                            => array(),
		'h4'                            => array(),
		'h5'                            => array(),
		'h6'                            => array(),
		'i'                             => array(
			'class' => array(),
		),
		'img'                           => array(
			'alt'    => array(),
			'class'  => array(),
			'height' => array(),
			'src'    => array(),
			'width'  => array(),
		),
		'li'                            => array(
			'class' => array(),
		),
		'ol'                            => array(
			'class' => array(),
		),
		'p'                             => array(
			'class' => array(),
		),
		'q'                             => array(
			'cite'  => array(),
			'title' => array(),
		),
		'span'                          => array(
			'class' => array(),
			'title' => array(),
			'style' => array(),
		),
		'iframe'                        => array(
			'scrolling'   => array(),
			'allow'       => array(),
			'src'         => array(),
		),
		'strike'                        => array(),
		'br'                            => array(),
		'strong'                        => array(),
		'data-wow-duration'             => array(),
		'data-wow-delay'                => array(),
		'data-wallpaper-options'        => array(),
		'data-stellar-background-ratio' => array(),
		'ul'                            => array(
			'class' => array(),
		),
	);

	if(function_exists('wp_kses')) { // WP is here
		$allowed = wp_kses($raw, $allowed_tags);
	} else {
		$allowed = $raw;
	}

	return $allowed;
}


// build google font url
// ----------------------------------------------------------------------------------------
function cuinare_google_fonts_url($font_families = []) {
	$fonts_url = '';
	/*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
    */
	if($font_families && 'off' !== _x('on', 'Google font: on or off', 'cuinare')) {
		$query_args = array(
			'family' => urlencode(implode('|', $font_families))
		);

		$fonts_url = add_query_arg($query_args, 'https://fonts.googleapis.com/css');
	}

	return esc_url_raw($fonts_url);
}


// return megamenu child item's slug
// ----------------------------------------------------------------------------------------
// function cuinare_get_mega_item_child_slug($location, $option_id) {
// 	$mega_item = '';
// 	$locations = get_nav_menu_locations();
// 	$menu = wp_get_nav_menu_object($locations[$location]);
// 	$menuitems = wp_get_nav_menu_items($menu->term_id);

// 	foreach($menuitems as $menuitem) {

// 		$id = $menuitem->ID;
// 		$mega_item = fw_ext_mega_menu_get_db_item_option($id, $option_id);
// 	}

// 	return $mega_item;
// }


// return cover image from an youtube video url
// ----------------------------------------------------------------------------------------
function cuinare_youtube_cover($e) {
	$src = null;
	//get the url
	if($e != '') {
		$url = $e;
		$queryString = parse_url($url, PHP_URL_QUERY);
		parse_str($queryString, $params);
		$v = $params['v'];
		//generate the src
		if(strlen($v) > 0) {
			$src = "http://i3.ytimg.com/vi/$v/default.jpg";
		}
	}

	return $src;
}


// return embed code for sound cloud
// ----------------------------------------------------------------------------------------
function cuinare_soundcloud_embed($url) {
	return 'https://w.soundcloud.com/player/?url=' . urlencode($url) . '&auto_play=false&color=915f33&theme_color=00FF00';
}


// return embed code video url
// ----------------------------------------------------------------------------------------
function cuinare_video_embed($url) {
	//This is a general function for generating an embed link of an FB/Vimeo/Youtube Video.
	$embed_url = '';
	if(strpos($url, 'facebook.com/') !== false) {
		//it is FB video
		$embed_url = 'https://www.facebook.com/plugins/video.php?href=' . rawurlencode($url) . '&show_text=1&width=200';
	} else {
		if(strpos($url, 'vimeo.com/') !== false) {
			//it is Vimeo video
			$video_id = explode("vimeo.com/", $url)[1];
			if(strpos($video_id, '&') !== false) {
				$video_id = explode("&", $video_id)[0];
			}
			$embed_url = 'https://player.vimeo.com/video/' . $video_id;
		} else {
			if(strpos($url, 'youtube.com/') !== false) {
				//it is Youtube video
				$video_id = explode("v=", $url)[1];
				if(strpos($video_id, '&') !== false) {
					$video_id = explode("&", $video_id)[0];
				}
				$embed_url = 'https://www.youtube.com/embed/' . $video_id;
			} else {
				if(strpos($url, 'youtu.be/') !== false) {
					//it is Youtube video
					$video_id = explode("youtu.be/", $url)[1];
					if(strpos($video_id, '&') !== false) {
						$video_id = explode("&", $video_id)[0];
					}
					$embed_url = 'https://www.youtube.com/embed/' . $video_id;
				} else {
					//for new valid video URL
				}
			}
		}
	}

	return $embed_url;
}

if(!function_exists('cuinare_advanced_font_styles')) :

	/**
	 * Get shortcode advanced Font styles
	 *
	 */
	function cuinare_advanced_font_styles($style) {

		$font_styles = $font_weight = '';

		$font_weight = (isset($style['font-weight']) && $style['font-weight']) ? 'font-weight:' . esc_attr($style['font-weight']) . ';' : '';
		$font_weight = (isset($style['variation']) && $style['variation']) ? 'font-weight:' . esc_attr($style['variation']) . ';' : $font_weight;

		$font_styles .= isset($style['family']) ? 'font-family:"' . $style['family'] . '";' : '';
		$font_styles .= isset($style['style']) && $style['style'] ? 'font-style:' . esc_attr($style['style']) . ';' : '';

		$font_styles .= isset($style['color']) && !empty($style['color']) ? 'color:' . esc_attr($style['color']) . ';' : '';
		$font_styles .= isset($style['line-height']) && !empty($style['line-height']) ? 'line-height:' . esc_attr($style['line-height']) . 'px;' : '';
		$font_styles .= isset($style['letter-spacing']) && !empty($style['letter-spacing']) ? 'letter-spacing:' . esc_attr($style['letter-spacing']) . 'px;' : '';
		$font_styles .= isset($style['size']) && !empty($style['size']) ? 'font-size:' . esc_attr($style['size']) . 'px;' : '';

		$font_styles .= !empty($font_weight) ? $font_weight : '';

		return !empty($font_styles) ? $font_styles : '';
	}

endif;

/**
 * include framework options
 *
 */

function include_framework_options($option_list, $folder_name, $prefix = "") {

	foreach($option_list as $option) {
		$filename = CUINARE_COMPONENTS . '/theme-options/' . $folder_name . '/options-' . $option . '.php';
		if(file_exists($filename)) {
			require_once($filename);
		}
	}
}

/*
* Social Share Hook Function
*/


if(!function_exists('cuinare_social_share')) {

    function cuinare_social_share( ) {
       $social_share_shortcode = cuinare_option('social_short_code');
       if($social_share_shortcode != ''): ?>
          <div class="single-product-social-share">
             <?php
                echo '<h4>' . esc_html('Share:', 'cuinare') . '</h4>';
                echo do_shortcode($social_share_shortcode); 
               ;
             ?>
          </div>
       <?php 
       endif;
   
    }  
 }
 function cuinare_product_sold_by($product_id) {

	$seller = get_post_field('post_author', $product_id);
	$author = get_user_by('id', $seller);
	$vendor = dokan()->vendor->get($seller);

	$store_info = dokan_get_store_info($author->ID);

	if(!empty($store_info['store_name'])) : ?>
	<?php endif;

}

 add_filter( 'woocommerce_share', 'cuinare_social_share', 20 );


 //  Overwrite WooCommerce Shop Page Pagination Icons
 add_filter("woocommerce_pagination_args", function(){
	return array( 
		'prev_text' => is_rtl() ? "<i class='tsicon tsicon-left-solid-arrow'></i>" : "<i class='tsicon tsicon-left-solid-arrow'></i>",
		'next_text' => is_rtl() ? "<i class='tsicon tsicon-arrow_icon'></i>" : "<i class='tsicon tsicon-arrow_icon'></i>",
		'type'      => 'list',
		'end_size'  => 3,
		'mid_size'  => 3,
	);
 });
 


/*Extra field on the seller settings and show the value on the store banner -Dokan*/

// Add extra field in seller settings

add_filter( 'dokan_settings_form_bottom', 'extra_fields', 10, 2);

function extra_fields( $current_user, $profile_info ){
$seller_url= isset( $profile_info['seller_url'] ) ? $profile_info['seller_url'] : '';
?>
 <div class="gregcustom dokan-form-group">
        <label class="dokan-w3 dokan-control-label" for="setting_address">
            <?php _e( 'Store items type', 'dokan' ); ?>
        </label>
        <div class="dokan-w5">
            <input type="text" class="dokan-form-control input-md valid" name="seller_url" id="reg_seller_url" value="<?php echo $seller_url; ?>" />
        </div>
    </div>
    <?php
}

    //save the field value
add_action( 'dokan_store_profile_saved', 'save_extra_fields', 15 );
function save_extra_fields( $store_id ) {
    $dokan_settings = dokan_get_store_info($store_id);
    if ( isset( $_POST['shop_gst'] ) ) {
        $dokan_settings['shop_gst'] = $_POST['shop_gst'];
    }
    elseif  ( isset( $_POST['shop_pan'] ) ) {
        $dokan_settings['shop_pan'] = $_POST['shop_pan'];
    }
    elseif  ( isset( $_POST['shop_fssai'] ) ) {
        $dokan_settings['shop_fssai'] = $_POST['shop_fssai'];
    }
    elseif  ( isset( $_POST['shop_nutrition'] ) ) {
        $dokan_settings['shop_nutrition'] = $_POST['shop_nutrition'];
    }
    elseif  ( isset( $_POST['seller_url'] ) ) {
        $dokan_settings['seller_url'] = $_POST['seller_url'];
    }
    
    
 update_user_meta( $store_id, 'dokan_profile_settings', $dokan_settings );
$test = get_user_meta( $store_id, 'dokan_profile_settings' );
}

  // adding field value in backend admin user profile area

add_action( 'dokan_seller_meta_fields', 'more_fields', 10 );
add_action( 'dokan_process_seller_meta_fields', 'process_more_fields', 10 );


function more_fields($user){
    
$store_settings        = dokan_get_store_info( $user->ID );

$shopgst        = isset( $store_settings['shop_gst'] ) ? $store_settings['shop_gst'] : '';
$shoppan        = isset( $store_settings['shop_pan'] ) ? $store_settings['shop_pan'] : '';
$shopfssai      = isset( $store_settings['shop_fssai'] ) ? $store_settings['shop_fssai'] : '';
$shopnutrition  = isset( $store_settings['shop_nutrition'] ) ? $store_settings['shop_nutrition'] : '';
?>
     <tr>
                    <th><?php esc_html_e( 'GST Number', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="dokan_store_gst" class="regular-text" value="<?php echo esc_attr( $store_settings['shop_gst'] ); ?>">
                    </td>
                </tr>
                
                 <tr>
                    <th><?php esc_html_e( 'PAN Number', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="dokan_store_pan" class="regular-text" value="<?php echo esc_attr( $store_settings['shop_pan'] ); ?>">
                    </td>
                </tr>
                
                <tr>
                    <th><?php esc_html_e( 'FSSAI License', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="dokan_store_fssai" class="regular-text" value="<?php echo esc_attr( $store_settings['shop_fssai'] ); ?>">
                    </td>
                </tr>
                
                
                <tr>
                    <th><?php esc_html_e( 'Nutrition Label', 'dokan-lite' ); ?></th>
                    <td>
                        <input type="text" name="dokan_store_nutrition" class="regular-text" value="<?php echo esc_attr( $store_settings['shop_nutrition'] ); ?>">
                    </td>
                </tr>
    
 <?php
}

    // show on the store page

add_action( 'dokan_store_header_info_fields', 'save_seller_url', 10);

function save_seller_url($store_user){

    $store_info    = dokan_get_store_info( $store_user);

   ?>
        <?php if ( isset( $store_info['seller_url'] ) && !empty( $store_info['seller_url'] ) ) { ?>
            <i class="fa fa-globe"></i>
            <a href="<?php echo esc_html( $store_info['seller_url'] ); ?>"><?php echo esc_html( $store_info['seller_url'] ); ?></a>
    
    <?php } ?>
       
  <?php

}