<?php 

class Cuinare_Modules{

    static function module_url(){
        return plugin_dir_url( __FILE__ );
    }

    public function run(){
        // die('foo');

        add_action('elementskit/loaded', function(){
            
            if(\ElementsKit_Lite::package_type() == 'free' && !in_array('elementskit/elementskit.php', apply_filters('active_plugins', get_option('active_plugins')))){
                $this->include_files();
                $this->load_classes();
                add_action( 'wp_enqueue_scripts', [$this, 'scripts'] );
            }

        });

    }

    public function scripts(){
        wp_enqueue_script( 'chart-kit-js', self::module_url() . 'elements/chart/assets/js/chart.js', array( 'jquery' ), false, true );
    }

    public function load_assets(){

    }

    public function ekit_por_widget_styles(){
        // ekit pro widget style
        wp_enqueue_style( 'cuinare-widget-styles-pro', self::module_url() . 'elements/assets/css/widget-styles-pro.css', null, \cuinare_Essentials_Includes::version() );
    }

    public function ekit_por_widget_scripts(){
        // ekit pro widget script
        $parallax_sticky = (function_exists('cuinare_option'))?cuinare_option('optimization_parallax_sticky', 'yes'): 'yes';
            wp_enqueue_script( 'cuinare-widget-scripts-pro', self::module_url() . 'elements/assets/js/widget-scripts-pro.js', array( 'jquery', 'elementor-frontend' ), \cuinare_Essentials_Includes::version(), true );
    }
    
    public function load_classes(){
        $parallax_sticky = (function_exists('cuinare_option'))?cuinare_option('optimization_parallax_sticky', 'yes'): 'yes';
            new ElementsKit\Modules\Parallax\Init();
            new ElementsKit\Modules\Sticky_Content\Init();
        
    }

    public function include_files(){
        include 'sticky-content/init.php';
        include 'elements/chart/chart.php';
        include 'elements/blog-posts/blog-posts.php';
        include 'elements/client-logo/client-logo.php';
        include 'parallax/init.php';
        include 'food-delivery/food-delivery.php';
    }

    public static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {

            // Fire the class instance
            self::$instance = new self();
            self::$instance;
        }

        return self::$instance;
    }
    
}

Cuinare_Modules::instance()->run();