<?php

namespace Elementor;

if(!defined('ABSPATH')) {
	exit;
}

class cuinare_Vendor_Grid extends Widget_Base {
	public $base;

	public function get_title() {

		return esc_html__('Vendor Grid', 'cuinare');

	}

	public function get_icon() {
		return 'eicon-call-to-action';
	}

	public function get_categories() {
		return ['cuinare-elements'];
	}

	public function get_menus() {
		$list  = [];
		$menus = wp_get_nav_menus();
		foreach($menus as $menu) {
			$list[$menu->slug] = $menu->name;
		}

		return $list;
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_tab',
			[
				'label' => esc_html__('Vendor Grid Settings', 'cuinare'),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'vendor_count',
			[
				'label'   => esc_html__('Vendor Count', 'Cafesio'),
                'type'    => Controls_Manager::NUMBER,
                'default' => '6',
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'vendor_style_tab',
			[
				'label' => esc_html__('Vendor Image Style', 'cuinare'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'vendor_image_border_radious',
			[
				'label'      => esc_html__('Border Radius', 'cuinare'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'default'    => [
					'top'      => '50',
					'right'    => '50',
					'bottom'   => '50',
					'left'     => '50',
					'unit'     => '%',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .seller-avatar img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'bannar_style_tab',
			[
				'label' => esc_html__('Bannar Area Style', 'cuinare'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'bannar_border_radious',
			[
				'label'      => esc_html__('Border Radius', 'cuinare'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'default'    => [
					'top'      => '6',
					'right'    => '6',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .store-banner img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'content_style_tab',
			[
				'label' => esc_html__('Content Area Style', 'cuinare'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'content_background_color',
			[
				'label'     => esc_html__('Background Color', 'cuinare'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#f8f8f8',
				'selectors' => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .store-content' => 'background: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'content_background_hover_color',
			[
				'label'     => esc_html__('Hover Background Color', 'cuinare'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#F84D17',
				'selectors' => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .ts-single-vendor:hover .store-content' => 'background: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'content_area_padding',
			[
				'label'      => esc_html__('Padding', 'cuinare'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px'],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '0',
					'left'     => '0',
					'unit'     => 'px',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .store-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'content_area_border_radious',
			[
				'label'      => esc_html__('Border Radius', 'cuinare'),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'default'    => [
					'top'      => '0',
					'right'    => '0',
					'bottom'   => '6',
					'left'     => '6',
					'unit'     => 'px',
					'isLinked' => false,
				],
				'selectors'  => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .store-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'           => 'button_typography',
				'label'          => esc_html__('Button Typography', 'cuinare'),
				'selector'       => '{{WRAPPER}} .ts-vendor-grid-wrapper .ts-vendor-button',
				'fields_options' => [
					'typography'  => [
						'default' => 'custom',
					],
					'font_weight' => [
						'default' => '500',
					],
					'font_size'   => [
						'default'    => [
							'size' => '14',
							'unit' => 'px'
						],
						'label'      => esc_html__('Font Size (px)', 'cuinare'),
						'size_units' => ['px']
					],
					'line_height' => [
						'default'    => [
							'size' => '32',
							'unit' => 'px'
						],
						'label'      => esc_html__('Line Height (px)', 'cuinare'),
						'size_units' => ['px'] // enable only px
					]
				],
				'exclude'        => [
					'font_family',
					'letter_spacing',
					'word_spacing',
					'text_transform',
					'text_decoration',
					'font_style'
				],
			)
		);
		$this->add_control(
			'button_background_color',
			[
				'label'     => esc_html__('Background Color', 'cuinare'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#F84D17',
				'selectors' => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .ts-vendor-button' => 'background: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'button_background_hover_color',
			[
				'label'     => esc_html__('Hover Background Color', 'cuinare'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => [
					'{{WRAPPER}} .ts-vendor-grid-wrapper .ts-vendor-button:hover' => 'background: {{VALUE}};',
				]
			]
		);
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		$vendor_per_page = $settings['vendor_count'];

      if(class_exists('WeDevs_Dokan')) :
        $sellers = dokan_get_sellers();
       
		$template_args = array(
			'sellers'   => $sellers,
		);
?>
    <div class="ts-vendor-grid-wrapper ts-vendor-listing-widget">
      <div id="dokan-seller-listing-wrap" class="dokan-seller-listing-store-grid grid-view view-1 tw-dokan-seller-listing">
         <div class="seller-listing-content">
            <?php if ( $sellers['users'] ) : ?>
                  <ul class="dokan-seller-wrap">
                     <?php
					 $i = 0;
                     foreach ( $sellers['users'] as $seller ) {
						if( $i == $vendor_per_page) break;
                        $vendor            = dokan()->vendor->get( $seller->ID );
                        $store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
                        $store_banner_id   = $vendor->get_banner_id();
                        $store_name        = $vendor->get_shop_name();
                        $store_url         = $vendor->get_shop_url();
                        $store_rating      = $vendor->get_rating();
                        $is_store_featured = $vendor->is_featured();
                        $store_phone       = $vendor->get_phone();
                        $per_row = '';
                        
                         $image_size = '';
                        $store_banner_url  = $store_banner_id ? wp_get_attachment_image_src( $store_banner_id, $image_size ) : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
                        $store_info        = dokan_get_store_info( $seller->ID );
                        $store_address     = dokan_get_seller_short_address( $seller->ID );DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
                        $show_store_open_close    = dokan_get_option( 'store_open_close', 'dokan_appearance', 'on' );
                        $dokan_store_time_enabled = isset( $store_info['dokan_store_time_enabled'] ) ? $store_info['dokan_store_time_enabled'] : '';
                        $store_open_is_on = ( 'on' === $show_store_open_close && 'yes' === $dokan_store_time_enabled && ! $is_store_featured ) ? 'store_open_is_on' : '';
                        ?>

                        <li class="dokan-single-seller woocommerce column-<?php echo esc_attr( $per_row ); ?> <?php echo ( ! $store_banner_id ) ? 'no-banner-img' : ''; ?>">
                              <div class="store-wrapper">
                                 <div class="store-header">
                                    <div class="store-banner">
                                          <a href="<?php echo esc_url( $store_url ); ?>">
                                             <img src="<?php echo is_array( $store_banner_url ) ? esc_attr( $store_banner_url[0] ) : esc_attr( $store_banner_url ); ?>">
                                          </a>
                                    </div>
                                 </div>

                                 <div class="store-body">
                                 <div class="seller-info-wrap">
                                    <div class="seller-avatar">
                                          <a href="<?php echo esc_url( $store_url ); ?>">
                                             <img src="<?php echo esc_url( $vendor->get_avatar() ) ?>"
                                             alt="<?php echo esc_attr( $vendor->get_shop_name() ) ?>"
                                             size="150">
                                          </a>
                                    </div>
                                    <?php do_action( 'dokan_seller_listing_footer_content', $seller, $store_info ); ?>
                                 
                                 

                                 <div class="store-content <?php echo ! $store_banner_id ? esc_attr( 'default-store-banner' ) : '' ?>">
                                    <div class="store-data-container">
                                          <div class="featured-favourite">
                                             <?php if ( $is_store_featured ) : ?>
                                                <div class="featured-label"><?php esc_html_e( 'Featured', 'dokan-lite' ); ?></div>
                                             <?php endif ?>

                                             <?php do_action( 'dokan_seller_listing_after_featured', $seller, $store_info ); ?>
                                          </div>
                                          <?php if ( 'on' === $show_store_open_close && 'yes' === $dokan_store_time_enabled ) : ?>
                                             <?php if ( dokan_is_store_open( $seller->ID ) ) { ?>
                                                <span class="dokan-store-is-open-close-status dokan-store-is-open-status" title="<?php esc_attr_e( 'Store is Open', 'dokan-lite' );?>"><?php esc_html_e( 'Open', 'dokan-lite' ); ?></span>
                                             <?php } else { ?>
                                                <span class="dokan-store-is-open-close-status dokan-store-is-closed-status" title="<?php esc_attr_e( 'Store is Closed', 'dokan-lite' );?>"><?php esc_html_e( 'Closed', 'dokan-lite' ); ?></span>
                                             <?php } ?>
                                          <?php endif ?>

                                          <div class="store-data <?php echo esc_attr( $store_open_is_on ); ?>">
                                             <h2><a href="<?php echo esc_attr( $store_url ); ?>"><?php echo esc_html( $store_name ); ?></a> <?php apply_filters( 'dokan_store_list_loop_after_store_name', $vendor ); ?></h2>

                                             <?php if ( !empty( $store_rating['count'] ) ): ?>
                                                <div class="dokan-seller-rating" title="<?php echo sprintf( esc_attr__( 'Rated %s out of 5', 'dokan-lite' ), esc_attr( $store_rating['rating'] ) ) ?>">
                                                      <?php echo wp_kses_post( dokan_generate_ratings( $store_rating['rating'], 5 ) ); ?>
                                                      <p class="rating">
                                                         <?php echo esc_html( sprintf( __( '%s out of 5', 'dokan-lite' ), $store_rating['rating'] ) ); ?>
                                                      </p>
                                                </div>
                                             <?php endif ?>

                                             <?php if ( ! dokan_is_vendor_info_hidden( 'address' ) && $store_address ): ?>
                                                <?php
                                                      $allowed_tags = array(
                                                         'span' => array(
                                                            'class' => array(),
                                                         ),
                                                      );
                                                ?>
                                                <p class="store-address"><?php echo wp_kses( $store_address, $allowed_tags ); ?></p>
                                             <?php endif ?>

                                             <?php do_action( 'dokan_seller_listing_after_store_data', $seller, $store_info ); ?>
                                          </div>
                                    </div>
                                    
                                 </div>
                              </div>
                              
                              <?php
                              $store_related_category = get_user_meta($vendor->id , 'dokan_profile_settings'); 
                              $seller_rel_product = [];
                              if(isset ( $store_related_category[0]['seller_url'])){
                                 $seller_rel_product = $store_related_category[0]['seller_url'];
                                 $seller_rel_product  = explode(",",$seller_rel_product);
                              }
                              
               
                              ?>
                                 <div class="dokan-related-cat">
                                    <div class="related-cat-list">
                                          <?php
                                    foreach ( $seller_rel_product as $index => $seller_rel_cat ){
                                 ?>
                                          <a href="<?php echo esc_attr( $store_url ); ?>" class="related-cat-list"> <?php echo $seller_rel_cat ?> </a>
                                          
                                 <?php
                              }
                              ?>
                                    </div>
                                 </div>
                                       <?php           
                              
                              ?>

                                 <div class="tw-dokan-meta-info">
                                    <div class="dokan-store-rating">
                                          <i class="fas fa-star"></i>
                                          <?php echo wp_kses_post( dokan_get_readable_seller_rating( $store_user->get_id() ) ); ?>
                                    </div>
                                 </div>
                                 </div>
                              </div>
                        </li>

                     <?php $i++; } ?>
                     <div class="dokan-clearfix"></div>
                  </ul> <!-- .dokan-seller-wrap -->


            <?php else:  ?>
                  <p class="dokan-error"><?php esc_html_e( 'No vendor found!', 'dokan-lite' ); ?></p>
            <?php endif; ?>
         </div>
      </div>
    </div>
<?php else: ?>
    <p class="ts-notice"><?php esc_html_e('Pleae install and active Dokan Multivendor Plugin to use this widget.', 'cuinare'); ?></div>
<?php endif; ?>
<?php
	}

	public function get_name() {
		return 'vendor-grid';
	}

	protected function render_raw() {
		$settings = $this->get_settings_for_display();

		$tpl = get_widget_template($this->get_name());
		if(file_exists($tpl)) {
			include $tpl;
		}
	}

	protected function content_template() {

	}
}