<?php if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}
/**
 * dynamic css, generated by customizer options
 */

// display navigation to the next/previous set of posts
// ----------------------------------------------------------------------------------------
function cuinare_post_nav() {
// Don't print empty markup if there's nowhere to navigate.
	$next_post = get_next_post();
	$pre_post  = get_previous_post();
	if ( ! $next_post && ! $pre_post ) {
		return;
	}
	?>
    <nav class="post-navigation clearfix">
        <div class="post-previous">
			<?php if ( ! empty( $pre_post ) ): ?>
                <a href="<?php echo get_the_permalink( $pre_post->ID ); ?>">
                    <h3><?php echo get_the_title( $pre_post->ID ) ?></h3>
                    <span><i class="tsicon tsicon-l-arrow"></i><?php esc_html_e( 'Previous post', 'cuinare' ) ?></span>
                </a>
			<?php endif; ?>
        </div>
        <div class="post-next">
			<?php if ( ! empty( $next_post ) ): ?>
                <a href="<?php echo get_the_permalink( $next_post->ID ); ?>">
                    <h3><?php echo get_the_title( $next_post->ID ) ?></h3>

                    <span><?php esc_html_e( 'Next post', 'cuinare' ) ?> <i class="tsicon tsicon-right-arrow"></i></span>
                </a>
			<?php endif; ?>
        </div>
    </nav>
<?php }

if ( ! function_exists( 'cuinare_get_breadcrumbs' ) ) :
// display meta information for a specific post
// ----------------------------------------------------------------------------------------
	function cuinare_get_breadcrumbs( $seperator = '', $word = '' ) {
		echo '<ol class="breadcrumb" data-wow-duration="2s">';
		if ( ! is_home() ) {
			echo '<li><a href="';
			echo esc_url( get_home_url( '/' ) );
			echo '">';
			echo esc_html__( 'Home', 'cuinare' );
			echo "</a></li> " . esc_attr( $seperator );
			if ( is_category() || is_single() ) {
				echo '<li> <a href="';
				echo ( get_post_type( ) );
				echo '">';
				$category = get_the_category();
				$post     = get_queried_object();
				$postType = get_post_type_object( get_post_type( $post ) );
				
				if ( ! empty( $category ) ) {
					echo esc_html( $category[0]->cat_name ) . '</a></li>';
				} else {
					if ( $postType ) {
						echo esc_html( $postType->labels->singular_name ) . '</a></li>';
					}
				}

				if ( is_single() ) {
					echo esc_attr( $seperator ) . "  <li><a href=";
					echo esc_attr( get_the_title() );
					echo '>';
					echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
					echo '</a></li>';
				}
			} elseif ( is_page() ) {
				echo '<li>';
				echo esc_html( $word ) != '' ? wp_trim_words( get_the_title(), $word ) : get_the_title();
				echo '</li>';
			}
		}
		if ( is_tag() ) {
			single_tag_title();
		} elseif ( is_day() ) {
			echo "<li>" . esc_html__( 'Blogs for', 'cuinare' ) . " ";
			the_time( 'F jS, Y' );
			echo '</li>';
		} elseif ( is_month() ) {
			echo "<li>" . esc_html__( 'Blogs for', 'cuinare' ) . " ";
			the_time( 'F, Y' );
			echo '</li>';
		} elseif ( is_year() ) {
			echo "<li>" . esc_html__( 'Blogs for', 'cuinare' ) . " ";
			the_time( 'Y' );
			echo '</li>';
		} elseif ( is_author() ) {
			echo "<li>" . esc_html__( 'Author Blogs', 'cuinare' );
			echo '</li>';
		} elseif ( isset( $_GET['paged'] ) && ! empty( $_GET['paged'] ) ) {
			echo "<li>" . esc_html__( 'Blogs', 'cuinare' );
			echo '</li>';
		} elseif ( is_search() ) {
			echo "<li>" . esc_html__( 'Search Result', 'cuinare' );
			echo '</li>';
		} elseif ( is_404() ) {
			echo "<li>" . esc_html__( '404 Not Found', 'cuinare' );
			echo '</li>';
		}
		echo '</ol>';
	}
endif;

function cuinare_insurance_nav_link() {

	?>
    <nav class="post-navigation clearfix">
		<?php
		$prev_post = get_previous_post();
		if ( $prev_post ) {
			$prev_title = strip_tags( str_replace( '"', '', $prev_post->post_title ) );
			?>
            <div class="post-previous">
                <a href="<?php get_permalink( $prev_post->ID ); ?>">
                    <h3><?php echo esc_html( $prev_title ); ?></h3>
                    <span><i class="tsicon tsicon-l-arrow"></i><?php echo esc_html__( 'Previous post', 'cuinare' ); ?></span>
                </a>
            </div>
		<?php } ?>
		<?php $next_post = get_next_post();
		if ( $next_post ) {
			$next_title = strip_tags( str_replace( '"', '', $next_post->post_title ) );
			?>
            <div class="post-next">
                <a href="<?php get_permalink( $prev_post->ID ); ?>">
                    <h3> <?php echo esc_html( $next_title ); ?> </h3>
                    <span><?php echo esc_html__( 'Next post', 'cuinare' ); ?> <i class="tsicon tsicon-right-arrow"></i></span>
                </a>
            </div>
		<?php } ?>
    </nav>
	<?php
}


// display meta information for a specific post
// ----------------------------------------------------------------------------------------
function cuinare_post_meta() {
	?>
    <div class="post-meta">
		<?php

		$style_primary = cuinare_option( 'blog_author', false );
		if ( $style_primary == true ) :
			printf(
				'<span class="post-author"><i class="tsicon tsicon-user"></i> <a href="%2$s">%3$s</a></span>',
				get_avatar( get_the_author_meta( 'ID' ), 55 ),
				esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
				get_the_author()
			);
		endif;

		if ( get_post_type() === 'post' ) {
			echo '<span class="post-meta-date">
                  <i class="tsicon tsicon-clock-icon"></i>
                     ' . get_the_date() .
			     '</span>';
		}

		cuinare_post_meta_category();

		?>
    </div>
<?php }

if ( ! function_exists( 'cuinare_post_meta_category' ) ) :
// display meta information for a specific post
// ----------------------------------------------------------------------------------------
	function cuinare_post_meta_category() {
		?>

		<?php

		$category_list = get_the_category_list( ', ' );
		if ( $category_list ) {
			echo '<span class="meta-categories post-cat">
                     <i class="tsicon tsicon-category"></i>
                        ' . $category_list . ' 
                     </span>';
		}

		?>

	<?php }

endif;


// display meta date for a specific post
// ----------------------------------------------------------------------------------------
function cuinare_post_meta_date() {
	if ( get_post_type() === 'post' ) {

		echo '<span class="post-meta-date meta-date">
				<span class="day">' . get_the_date( 'm' ) . '</span>
				' . get_the_date( 'M' ) .
		     '</span>';
	}
}

// comment walker
// ----------------------------------------------------------------------------------------
function cuinare_comment_style( $comment, $args, $depth ) {
	if ( 'div' === $args['style'] ) {
		$tag       = 'div';
		$add_below = 'comment';
	} else {
		$tag       = 'li ';
		$add_below = 'div-comment';
	}
	?>
	<?php
	if ( $args['avatar_size'] != 0 ) {
		echo get_avatar( $comment, $args['avatar_size'], '', '', array( 'class' => 'comment-avatar float-left' ) );
	}
	?>
    <<?php
	echo cuinare_kses( $tag );
	comment_class( empty( $args['has_children'] ) ? '' : 'parent' );
	?> id="comment-<?php comment_ID() ?>"><?php if ( 'div' != $args['style'] ) { ?>
        <div id="div-comment-<?php comment_ID() ?>" class="comment-body"><?php }
	?>
    <div class="meta-data">

        <div class="pull-right reply"><?php
			comment_reply_link(
				array_merge(
					$args, array(
					'add_below' => $add_below,
					'depth'     => $depth,
					'max_depth' => $args['max_depth']
				) ) );
			?>
        </div>


        <span class="comment-author vcard"><?php
			printf( cuinare_kses( '<cite class="fn">%s</cite> <span class="says">%s</span>', 'cuinare' ), get_comment_author_link(), esc_html__( 'says:', 'cuinare' ) );
			?>
			</span>
		<?php if ( $comment->comment_approved == '0' ) { ?>
            <em class="comment-awaiting-moderation"><?php esc_html_e( 'Your comment is awaiting moderation.', 'cuinare' ); ?></em>
            <br/><?php }
		?>

        <div class="comment-meta commentmetadata comment-date">
			<?php
			// translators: 1: date, 2: time
			printf(
				esc_html__( '%1$s at %2$s', 'cuinare' ), get_comment_date(), get_comment_time()
			);
			?>
			<?php edit_comment_link( esc_html__( '(Edit)', 'cuinare' ), '  ', '' ); ?>
        </div>
    </div>
    <div class="comment-content">
		<?php comment_text(); ?>
    </div>
	<?php if ( 'div' != $args['style'] ) : ?>
        </div><?php
	endif;
}


// pagination within pages or posts if it has a long content
// ----------------------------------------------------------------------------------------
function cuinare_link_pages() {
	$args = array(
		'before'           => '<div class="page-links"><span class="page-link-text">' . esc_html__( 'More pages: ', 'cuinare' ) . '</span>',
		'after'            => '</div>',
		'link_before'      => '<span class="page-link">',
		'link_after'       => '</span>',
		'next_or_number'   => 'number',
		'separator'        => '  ',
		'nextpagelink'     => esc_html__( 'Next ', 'cuinare' ) . '<i class="tsicon tsicon-right-arrow"></i>',
		'previouspagelink' => '<I class="fa fa-angle-left"></i>' . esc_html__( ' Previous', 'cuinare' ),
	);
	wp_link_pages( $args );
}


//  related post by categry
function cuinare_related_posts_by_category( $post_id, $related_count = 4, $feature_image = true ) {
	try {

		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}

		$terms = get_the_terms( $post_id, 'category' );

		if ( empty( $terms ) ) {
			$terms = array();
		}

		$term_list = wp_list_pluck( $terms, 'slug' );

		$related_args = array(
			'post_type'           => 'post',
			'posts_per_page'      => $related_count,
			'post_status'         => 'publish',
			'post__not_in'        => array( $post_id ),
			'orderby'             => 'rand',
			'ignore_sticky_posts' => 1,
			'tax_query'           => array(
				array(
					'taxonomy' => 'category',
					'field'    => 'slug',
					'terms'    => $term_list
				)
			)
		);
		if ( $feature_image ) {
			$related_args["meta_query"] = array(
				array(
					'key'     => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
			);
		}

		return new WP_Query( $related_args );

	} catch( Exception $e ) {

		return new WP_Query( [] );

	}
}

//  related post by tags
function cuinare_related_posts_by_tags( $post_id = '', $related_count = 4, $feature_image = true ) {

	try {
		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}
		$tags      = wp_get_post_tags( $post_id );
		$term_tags = wp_list_pluck( $tags, 'term_id' );
		$args      = array(

			'tag__in'             => $term_tags,
			'post__not_in'        => array( $post_id ),
			'posts_per_page'      => $related_count,
			'ignore_sticky_posts' => 1,
		);
		if ( $feature_image ) {
			$args["meta_query"] = array(
				array(
					'key'     => '_thumbnail_id',
					'compare' => 'EXISTS'
				),
			);
		}

		return new WP_Query( $args );

	} catch( Exception $e ) {

		return new WP_Query( [] );

	}

}

//  case study related _post
function cuinare_related_case_by_category( $post_id, $related_count = 4, $feature_image = true ) {
	try {

		if ( $post_id == '' ) {
			$post_id = get_the_ID();
		}

		$terms = get_the_terms( $post_id, 'category' );

		if ( empty( $terms ) ) {
			$terms = array();
		}

		$term_list = wp_list_pluck( $terms, 'slug' );

		$related_args = array(
			'post_type'           => 'blo-case-study',
			'posts_per_page'      => $related_count,
			'post_status'         => 'publish',
			'post__not_in'        => array( $post_id ),
			'orderby'             => 'rand',
			'ignore_sticky_posts' => 1,
			'tax_query'           => array(
				array(
					'taxonomy' => 'blo-case-study',
					'field'    => 'slug',
					'terms'    => $term_list
				)
			)
		);

		return new WP_Query( $related_args );

	} catch( Exception $e ) {

		return new WP_Query( [] );

	}
}

