<?php 

add_filter('woocommerce_add_to_cart_fragments', 'cuinare_woocommerce_header_add_to_cart_fragment');

function cuinare_woocommerce_header_add_to_cart_fragment( $fragments ) 
{
  
      ob_start(); ?>
      <a class="cart-contents" href="<?php echo wc_get_cart_url(); ?>" title="<?php esc_html_e('View your shopping cart', 'cuinare'); ?>">
      <span class="icon icon-tscart"></span>
      <sup><?php echo sprintf(_n('%d item', '%d', WC()->cart->cart_contents_count, 'cuinare'), WC()->cart->cart_contents_count);?></sup>
                           
      </a>

    <?php
    $fragments['a.cart-contents'] = ob_get_clean();
    return $fragments;
}

/*
 * cuinare product loop buttons
 * */
function cuinare_product_loop_buttons($product_id, $add_to_cart_text = '') {
	?>
    <div class="add-to-cart-hover-box">
		<?php
		$args = [];
		$product = wc_get_product($product_id);
		if($product) {
			$defaults = array(
				'quantity'   => 1,
				'class'      => implode(
					' ',
					array_filter(
						array(
							'button',
							'product_type_' . $product->get_type(),
							$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
							$product->supports('ajax_add_to_cart') && $product->is_purchasable() && $product->is_in_stock() ? 'ajax_add_to_cart' : '',
						)
					)
				),
				'attributes' => array(
					'data-product_id'  => $product->get_id(),
					'data-product_sku' => $product->get_sku(),
					'aria-label'       => $product->add_to_cart_description(),
					'rel'              => 'nofollow',
				),
			);

			$args = apply_filters('woocommerce_loop_add_to_cart_args', wp_parse_args($args, $defaults), $product);

			if(isset($args['attributes']['aria-label'])) {
				$args['attributes']['aria-label'] = wp_strip_all_tags($args['attributes']['aria-label']);
			}

			echo apply_filters(
				'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
				sprintf(
					'<a href="%s" data-quantity="%s" class="%s" %s>%s</a>',
					esc_url($product->add_to_cart_url()),
					esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
					esc_attr(isset($args['class']) ? $args['class'] : 'button'),
					isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
					!empty($add_to_cart_text) ? esc_html($add_to_cart_text) : esc_html($product->add_to_cart_text())
				),
				$product,
				$args
			);
		}
		?>
    </div>
	<?php
}

/*
 * cuinare product loop item
 * */
if(!function_exists('cuinare_woocommerce_loop_item')) {
	function cuinare_woocommerce_loop_item($product_id, $title_crop, $show_description = 'no', $description_characters = 10, $show_rating = 'no', $show_buttons_on_hover = 'no', $show_category_list = 'yes', $show_color_swatches = 'no') {
		$percentage = '';
		$product = wc_get_product($product_id);
		global $post;
		$image_size = apply_filters('single_product_archive_thumbnail_size', 'woocommerce_thumbnail');
		?>
        <div class="shop-loop-item product">
            <div class="shop-loop-thumb">
				<?php
				$product_gallery_ids = $product->get_gallery_image_ids();
				if(isset($product_gallery_ids[1])) {
					$image_url = wp_get_attachment_url($product_gallery_ids[1]);
				}
				?>

                <a href="<?php echo esc_url(get_permalink($product_id)); ?>"
                   title="<?php echo get_the_title($product_id); ?>"><?php echo cuinare_kses($product) ? $product->get_image($image_size) : ''; ?></a>

				<?php if($product->is_on_sale()) {
					if($product->is_type('variable')) {
						$percentages = array();
						$prices = $product->get_variation_prices(); 

						foreach($prices['price'] as $key => $price) {
							if($prices['regular_price'][$key] !== $price) {
								$percentages[] = round(100 - (floatval($prices['sale_price'][$key]) / floatval($prices['regular_price'][$key]) * 100));
							}
						}

						$percentage = max($percentages) . '%';
					} elseif($product->is_type('grouped')) {
						$percentages = array();
					} else {
						$regular_price = (float)$product->get_regular_price();
						$sale_price = (float)$product->get_sale_price();

						if($sale_price != 0 || !empty($sale_price)) {
							$percentage = round(100 - ($sale_price / $regular_price * 100)) . '%';
						} else {
							$percentage = '';
						}
					}
					echo apply_filters('woocommerce_sale_flash', '<span class="onsale-percentage">' . $percentage . esc_html__(' OFF', 'cuinare') . '</span>', $post, $product); ?>

				<?php } ?>
				<?php if('yes' !== $show_buttons_on_hover) : ?>
					<?php cuinare_product_loop_buttons($product_id); ?>
				<?php endif; ?>

            </div>
            <div class="product-loop-desc">
                <!-- Product category list -->
				<?php
				$product_categories = get_the_terms($product_id, 'product_cat');
				if('yes' === $show_category_list && !empty($product_categories)) { ?>
                    <ul class="product-categories">
						<?php
						foreach($product_categories as $key => $term) {
							if($key == 1) {
								break;
							} ?>
                            <li>
                                <a href="<?php echo esc_url(get_term_link($term->term_id, 'product_cat')); ?>"><?php echo esc_html($term->name); ?></a>
                            </li>
						<?php } ?>
                    </ul>
				<?php }
				?>

                <!-- Product title -->
                <h3 class="product-title">
                    <a href="<?php echo esc_url(get_permalink($product_id)); ?>"
                       title="<?php echo get_the_title($product_id); ?>">
						<?php echo wp_trim_words(get_the_title($product_id), $title_crop, ''); ?>
                    </a>
                </h3>

                <!-- Product short description block -->
				<?php if('yes' === $show_description) : ?>
                    <p class="product-short-description"><?php echo wp_trim_words(get_the_excerpt($product_id), $description_characters, ''); ?></p>
				<?php endif; ?>

                <!-- Product footer block -->
                <div class="product-footer-wrapper">
                    <div class="product-footer">
                        <!-- Product price block -->
						<?php
						$price_multiline = '';
						if('yes' === $show_rating) {
							$price_multiline = 'price-multiline';
						}
						?>
						<?php if($product->get_price_html()) { ?>
                            <span class="product-price <?php echo esc_attr($price_multiline); ?>">
                                    <?php echo cuinare_kses($product->get_price_html()); ?>
                                </span>
						<?php } ?>

                        <!-- Rating block -->
						<?php if('yes' === $show_rating && $product->get_rating_count() > 0) { ?>
                            <div class="product-rating">
								<?php woocommerce_template_loop_rating(); ?>
                            </div>
						<?php } ?>
                    </div>
                </div>
            </div>
        </div>
		<?php
	}
}
