<?php
/**
 * Theme's main functions and globally usable variables, contants etc
 * Added: v1.0.0
 * Textdomain: cuinare, class: CUINARE, var: $cuinare_, constants: CUINARE_, function: cuinare_
 */

// shorthand contants
// ------------------------------------------------------------------------
define( 'CUINARE_THEME', 'CUINARE Multi Vendor & Niche Restaurant WordPress Theme' );
define( 'CUINARE_VERSION', '1.0.6' );
define( 'CUINARE_MINWP_VERSION', '5.2' );


// shorthand contants for theme assets url
// ------------------------------------------------------------------------
define( 'CUINARE_THEME_URI', get_template_directory_uri() );
define( 'CUINARE_IMG', CUINARE_THEME_URI . '/assets/images' );
define( 'CUINARE_CSS', CUINARE_THEME_URI . '/assets/css' );
define( 'CUINARE_JS', CUINARE_THEME_URI . '/assets/js' );


// shorthand contants for theme assets directory path
// ----------------------------------------------------------------------------------------
define( 'CUINARE_THEME_DIR', get_template_directory() );
define( 'CUINARE_IMG_DIR', CUINARE_THEME_DIR . '/assets/images' );
define( 'CUINARE_CSS_DIR', CUINARE_THEME_DIR . '/assets/css' );
define( 'CUINARE_JS_DIR', CUINARE_THEME_DIR . '/assets/js' );

define( 'CUINARE_CORE', CUINARE_THEME_DIR . '/core' );
define( 'CUINARE_COMPONENTS', CUINARE_THEME_DIR . '/components' );
define( 'CUINARE_EDITOR', CUINARE_COMPONENTS . '/editor' );
define( 'CUINARE_EDITOR_ELEMENTOR', CUINARE_EDITOR . '/elementor' );
define( 'CUINARE_SHORTCODE_DIR_STYLE', CUINARE_EDITOR_ELEMENTOR . '/widgets/style' );
define( 'CUINARE_INSTALLATION', CUINARE_CORE . '/installation-fragments' );
define( 'CUINARE_REMOTE_CONTENT', esc_url( 'https://demo.themewinter.com/wp/demo-content/cuinare' ) );
define( 'CUINARE_LIVE_URL', esc_url( 'https://demo.themewinter.com/wp/cuinare/' ) );


// set up the content width value based on the theme's design
// ----------------------------------------------------------------------------------------
if ( ! isset( $content_width ) ) {
	$content_width = 800;
}

// set up theme default and register various supported features.
// ----------------------------------------------------------------------------------------

function cuinare_setup() {

	// make the theme available for translation
	$lang_dir = CUINARE_THEME_DIR . '/languages';
	load_theme_textdomain( 'cuinare', $lang_dir );

	// add support for post formats
	add_theme_support( 'post-formats', [
		'standard',
		'image',
		'video',
		'audio',
		'gallery'
	] );

	// add support for automatic feed links
	add_theme_support( 'automatic-feed-links' );

	// let WordPress manage the document title
	add_theme_support( 'title-tag' );

	// add support for post thumbnails
	add_theme_support( 'post-thumbnails' );

	// hard crop center center
	set_post_thumbnail_size( 750, 465, [ 'center', 'center' ] );
	add_image_size( 'cuinare-small', 350, 250, [ 'center', 'center' ] );
	add_image_size( 'cuinare-case-study-box', 320, 200, [ 'center', 'center' ] );

	// woocommerce support
	add_theme_support( 'woocommerce' );
	add_theme_support( 'woocommerce', array(
		'thumbnail_image_width'         => 600,
		'gallery_thumbnail_image_width' => 300,
		'single_image_width'            => 600,
	) );
	add_theme_support( 'wc-product-gallery-lightbox' );
	add_theme_support( 'wc-product-gallery-slider' );

	// register navigation menus
	register_nav_menus(
		[
			'primary'    => esc_html__( 'Primary Menu', 'cuinare' ),
		]
	);

	// HTML5 markup support for search form, comment form, and comments
	add_theme_support( 'html5', array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption'
	) );


}

add_action( 'after_setup_theme', 'cuinare_setup' );


add_action( 'enqueue_block_editor_assets', 'cuinare_action_enqueue_block_editor_assets' );
function cuinare_action_enqueue_block_editor_assets() {
	wp_enqueue_style( 'cuinare-google-fonts', cuinare_google_fonts_url( [
		'Open Sans:300,300i,400,400i,700,700i,800,900,900i',
		'Rubik:300,300i,400,400i,500,500i,700,700i,900,900i'
	] ), null, CUINARE_VERSION );
	wp_enqueue_style( 'cuinare-gutenberg-editor-font-awesome-styles-5', CUINARE_CSS . '/font-awesome.css', null, CUINARE_VERSION );
	wp_enqueue_style( 'cuinare-gutenberg-blog-styles', CUINARE_CSS . '/blog.css', null, CUINARE_VERSION );
}

// Multi Vendor Products
if(!function_exists('cuinare_multivendor_product_loop')) {
	function cuinare_multivendor_product_loop($product_id, $title_length = 10 , $excerpt_length = 10, $add_to_cart_text = '') {
		 global $post;
		 $product = wc_get_product($product_id);
		 $image_size = apply_filters('single_product_archive_thumbnail_size', 'thumbnail');
		 ?>
		 <div class="shop-loop-item single-product-item product">
			  <div class="shop-loop-thumb">
					<a class="product-image" href="<?php echo esc_url(get_permalink($product_id)); ?>"
						 title="<?php echo get_the_title($product_id); ?>">
						 <?php echo cuinare_kses($product) ? $product->get_image($image_size) : ''; ?>
					</a>
			  </div>
			  <div class="product-loop-desc">
					<!-- Product vendor name -->
					<?php
					if(class_exists('WeDevs_Dokan')) {
						//  cuinare_product_sold_by($product_id);
					}
					?>
					<!-- Product title -->
					<h3 class="product-title">
						 <a href="<?php echo esc_url(get_permalink($product_id)); ?>"
							  title="<?php echo get_the_title($product_id); ?>">
							  <?php echo wp_trim_words(get_the_title($product_id), 3, ''); ?>
						 </a>
					</h3>
					<p class="product-short-description">
						 <?php echo wp_trim_words(get_the_excerpt($product_id), 8, ''); ?>
					</p>
					<!-- Product footer block -->
					<div class="product-footer-wrapper">
						 <div class="product-price">
							  <!-- Product price block -->
							  <?php
							  $price_multiline = 'price-multiline';
							  ?>
							  <?php if($product->get_price_html()) { ?>
									<span class="product-price <?php echo esc_attr($price_multiline); ?>">
														 <?php echo cuinare_kses($product->get_price_html()); ?>
													</span>
							  <?php } ?>
						 </div>
						 <div class="product-footer-action-buttons">
							  <?php cuinare_product_loop_buttons($product_id, $add_to_cart_text); ?>
						 </div>
					</div>

			  </div>
		 </div>
		 <?php
	}
}


// To change add to cart text on single product page
add_filter( 'woocommerce_product_single_add_to_cart_text', 'woocommerce_custom_single_add_to_cart_text' ); 
function woocommerce_custom_single_add_to_cart_text($text) {
	if ( function_exists('dokan_is_store_page') && dokan_is_store_page() ) {
		return __( 'Add', 'woocommerce' );
	}

	return $text;
}

// To change add to cart text on product archives(Collection) page
add_filter( 'woocommerce_product_add_to_cart_text', 'woocommerce_custom_product_add_to_cart_text' );  
function woocommerce_custom_product_add_to_cart_text($text) {
	if ( function_exists('dokan_is_store_page') && dokan_is_store_page() ) {
		return __( 'Add', 'woocommerce' );
	}

	return $text;
}


// include the init.php
// ----------------------------------------------------------------------------------------
require_once( CUINARE_CORE . '/init.php' );
require_once( CUINARE_COMPONENTS . '/editor/elementor/elementor.php' );

// Framework option include
// ----------------------------------------------------------------------------------------
require_once( CUINARE_COMPONENTS . '/theme-options/init.php' );
if ( class_exists( 'CSF' ) ) {
	add_filter( 'csf_welcome_page', '__return_false' );
}

// Preloader function
// ----------------------------------------------------------------------------------------

function cuinare_preloader_function() {
	$preloader_show = cuinare_option( 'preloader_show', false );
	if ( $preloader_show == true ) {
		?>
        <div id="preloader">
            <div class="spinner">
                <div class="double-bounce1"></div>
                <div class="double-bounce2"></div>
            </div>
            <div class="preloader-cancel-btn-wraper">
                <span class="btn btn-primary preloader-cancel-btn"><?php echo esc_html__( 'Cancel Preloader', 'cuinare' ); ?></span>
            </div>
        </div>
		<?php
	}
}

add_action( 'wp_head', 'cuinare_preloader_function' );


// Delivery and Pickup  Added Tags
if( ! function_exists( 'add_default_product_tags' )) {
    function add_default_product_tags() {
        $org_term = term_exists( 'Pickup', 'product_tag' );
        if ( $org_term === null ) {
            wp_insert_term(
                'Pickup',
                'product_tag',
                [
                    'description' => 'Product for Pickup',
                    'slug'        => 'pickup',
                    'parent'      => 0,
                ]
            );
        }
    
        $product_term = term_exists( 'Delivery', 'product_tag' );
    
        if ( $product_term === null ) {
            wp_insert_term(
                'Delivery',
                'product_tag',
                [
                    'description' => 'Product for Delivery',
                    'slug'        => 'delivery',
                    'parent'      => 0,
                ]
            );
        }
    }
}
add_action( 'init', 'add_default_product_tags', 10 );
